/*************************************************
* CBC Padding Methods Header File                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_PADDING_H__
#define BOTAN_PADDING_H__

#include <botan/types.h>
#include <botan/exceptn.h>
#include <string>

namespace Botan {

/*************************************************
* Block Cipher Mode Padding Method Base Class    *
*************************************************/
class BlockCipherModePaddingMethod
   {
   public:
      virtual void pad(byte[], u32bit, u32bit) const = 0;
      virtual u32bit unpad(const byte[], u32bit) const = 0;
      virtual u32bit pad_bytes(u32bit, u32bit) const = 0;
      virtual bool valid_blocksize(u32bit) const = 0;
      virtual std::string name() const = 0;
   };

/*************************************************
* PKCS#7 Padding                                 *
*************************************************/
class PKCS7_Padding : public BlockCipherModePaddingMethod
   {
   public:
      void pad(byte[], u32bit, u32bit) const;
      u32bit unpad(const byte[], u32bit) const;
      u32bit pad_bytes(u32bit bs, u32bit pos) const { return (bs - pos); }
      bool valid_blocksize(u32bit) const;
      std::string name() const { return "PKCS7"; }
   };

/*************************************************
* One And Zeros Padding                          *
*************************************************/
class OneAndZeros_Padding : public BlockCipherModePaddingMethod
   {
   public:
      void pad(byte[], u32bit, u32bit) const;
      u32bit unpad(const byte[], u32bit) const;
      u32bit pad_bytes(u32bit bs, u32bit pos) const { return (bs - pos); }
      bool valid_blocksize(u32bit) const;
      std::string name() const { return "OneAndZeros"; }
   };

/*************************************************
* Null Padding                                   *
*************************************************/
class Null_Padding : public BlockCipherModePaddingMethod
   {
   public:
      void pad(byte[], u32bit, u32bit) const { return; }
      u32bit unpad(const byte[], u32bit size) const { return size; }
      u32bit pad_bytes(u32bit, u32bit) const { return 0; }
      bool valid_blocksize(u32bit) const { return true; }
      std::string name() const { return "NoPadding"; }
   };

}

#endif
