/*************************************************
* Low Level MPI Types Header File                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_MPI_TYPES_H__
#define BOTAN_MPI_TYPES_H__

#include <botan/config.h>

namespace Botan {

#if (MP_WORD_BITS == 8)
  typedef byte word;
  typedef u16bit dword;

  const word MP_WORD_MAX     = 0xFF;
  const word MP_WORD_TOP_BIT = 0x80;
  const dword MP_RADIX       = 0x100;
#elif (MP_WORD_BITS == 16)
  typedef u16bit word;
  typedef u32bit dword;

  const word MP_WORD_MAX     = 0xFFFF;
  const word MP_WORD_TOP_BIT = 0x8000;
  const dword MP_RADIX       = 0x10000;
#elif (MP_WORD_BITS == 32)
  typedef u32bit word;
  typedef u64bit dword;

  const word MP_WORD_MAX     = 0xFFFFFFFF;
  const word MP_WORD_TOP_BIT = 0x80000000;
  const dword MP_RADIX = 0x100000000;
#else
  #error MP_WORD_BITS must be 8, 16, or 32
#endif

}

#endif
