/*************************************************
* Mutex Factory Header File                      *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_MUTEX_H__
#define BOTAN_MUTEX_H__

#include <botan/config.h>

namespace Botan {

/*************************************************
* Mutex Base Class                               *
*************************************************/
class Mutex
   {
   public:
      virtual void lock() = 0;
      virtual void unlock() = 0;
      virtual Mutex* clone() const = 0;
      virtual ~Mutex() {}
   };

/*************************************************
* Get a mutex                                    *
*************************************************/
Mutex* get_mutex();

/*************************************************
* Set the mutex type                             *
*************************************************/
void set_mutex_type(Mutex*);

}

#endif
