/*************************************************
* Miscellaneous PK Functions Header File         *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_PUBKEY_MISC_H__
#define BOTAN_PUBKEY_MISC_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* Encoding Method for Encryption                 *
*************************************************/
class EME
   {
   public:
      virtual u32bit maximum_input_size(u32bit) const = 0;
      SecureVector<byte> encode(const byte[], u32bit, u32bit) const;
      SecureVector<byte> encode(const SecureVector<byte>&, u32bit) const;
      SecureVector<byte> decode(const byte[], u32bit, u32bit) const;
      SecureVector<byte> decode(const SecureVector<byte>&, u32bit) const;

      virtual ~EME() {}
   private:
      virtual SecureVector<byte> pad(const byte[], u32bit, u32bit) const = 0;
      virtual SecureVector<byte> unpad(const byte[], u32bit, u32bit) const = 0;
   };

/*************************************************
* Encoding Method for Signatures, Appendix       *
*************************************************/
class EMSA
   {
   public:
      virtual void update(const byte[], u32bit) = 0;
      virtual SecureVector<byte> raw_data() = 0;
      virtual SecureVector<byte> encoding_of(const SecureVector<byte>&,
                                             u32bit) = 0;
      virtual bool verify(const SecureVector<byte>&, const SecureVector<byte>&,
                          u32bit) throw();
      virtual ~EMSA() {}
   };

/*************************************************
* Mask Generation Function                       *
*************************************************/
class MGF
   {
   public:
      virtual void mask(const byte[], u32bit, byte[], u32bit) const = 0;
      virtual ~MGF() {}
   };

/*************************************************
* Key Derivation Function                        *
*************************************************/
class KDF
   {
   public:
      SymmetricKey derive_key(const byte[], u32bit, u32bit) const;
      SymmetricKey derive_key(const SecureVector<byte>&, u32bit) const;
      virtual ~KDF() {}
   private:
      virtual SymmetricKey derive(const byte[], u32bit, u32bit) const = 0;
   };

}

#endif
