/*************************************************
* RIPEMD-128 Header File                         *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_RIPEMD_128_H__
#define BOTAN_RIPEMD_128_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* RIPEMD-128                                     *
*************************************************/
class RIPEMD_128 : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "RIPEMD-128"; }
      HashFunction* clone() const { return new RIPEMD_128; }
      RIPEMD_128() : MDx_HashFunction(16, 64) { clear(); }
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u32bit&, u32bit, u32bit, u32bit, u32bit, byte, u32bit);
      static void F2(u32bit&, u32bit, u32bit, u32bit, u32bit, byte, u32bit);
      static void F3(u32bit&, u32bit, u32bit, u32bit, u32bit, byte, u32bit);
      static void F4(u32bit&, u32bit, u32bit, u32bit, u32bit, byte, u32bit);
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 4> digest;
   };

}

#endif
