/*************************************************
* Global RNG Header File                         *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_GLOBAL_RNG_H__
#define BOTAN_GLOBAL_RNG_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* RNG Access and Seeding Functions               *
*************************************************/
namespace Global_RNG {

void randomize(byte[], u32bit);
byte random();

void add_entropy(const byte[], u32bit);
void add_entropy(EntropySource&, bool = true);
bool seed(u32bit = 2, const std::string& = "/var/run/egd-pool");

}

/*************************************************
* RNG Control Functions                          *
*************************************************/
void set_global_rng(RandomNumberGenerator*);

}

#endif
