/*************************************************
* SEAL Header File                               *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SEAL_H__
#define BOTAN_SEAL_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* SEAL                                           *
*************************************************/
class SEAL : public StreamCipher
   {
   public:
      void seek(u32bit);

      void clear() throw();
      std::string name() const;
      StreamCipher* clone() const;
      SEAL(u32bit = 16, u32bit = 0);
   private:
      void cipher(const byte[], byte[], u32bit);
      void key(const byte[], u32bit);
      void generate(u32bit);
      const u32bit START, STATESIZE;
      SecureVector<byte> state;
      SecureBuffer<u32bit, 512> T;
      SecureBuffer<u32bit, 256> S;
      SecureVector<u32bit> R;
      u32bit counter, position;
      };

}

#endif
