/*************************************************
* SHA2-384 Header File                           *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SHA2_384_H__
#define BOTAN_SHA2_384_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* SHA2-384                                       *
*************************************************/
class SHA2_384 : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "SHA2-384"; }
      HashFunction* clone() const { return new SHA2_384; }
      SHA2_384() : MDx_HashFunction(48, 128) { clear(); }
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u64bit, u64bit, u64bit, u64bit&, u64bit,
                     u64bit, u64bit, u64bit&, u64bit, u64bit);
      static u64bit rho(u64bit, u32bit, u32bit, u32bit);
      static u64bit sigma(u64bit, u32bit, u32bit, u32bit);
      SecureBuffer<u64bit, 80> W;
      SecureBuffer<u64bit, 8> digest;
   };

}

#endif
