/*************************************************
* Timestamp Functions Header File                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_TIMERS_H__
#define BOTAN_TIMERS_H__

#include <botan/config.h>

namespace Botan {

/*************************************************
* Timer Base Class                               *
*************************************************/
class Timer
   {
   public:
      virtual u64bit clock() const = 0;
      virtual ~Timer() {}
   };

/*************************************************
* Timer Access Functions                         *
*************************************************/
u64bit system_time();
u64bit system_clock();

/*************************************************
* Timer Control Functions                        *
*************************************************/
void set_timer_type(Timer*);

}

#endif
