#	$Id: bt.prog.mk,v 1.11 2003/02/03 16:21:21 jmmv Exp $
#	$NetBSD: bsd.prog.mk,v 1.156 2002/08/09 00:21:22 thorpej Exp $
#	@(#)bsd.prog.mk	8.2 (Berkeley) 4/2/94

.include <bt.init.mk>

.SUFFIXES: .c .cc .cpp .o .h .sh .m4 .y .s .S

# --------------------------------------------------------------------
# Basic targets
# --------------------------------------------------------------------

.PHONY:		_proginstall _progdeinstall
real-install:	_proginstall
real-deinstall:	_progdeinstall

# --------------------------------------------------------------------
# Implicit conversions
# --------------------------------------------------------------------

.c.o:
	@${BT_LOGIC} compile-prog cc ${BT_FLAGS_CPP} ${BT_FLAGS_CC} \
	            -c ${.IMPSRC} -o ${.TARGET}

.cc.o:
	@${BT_LOGIC} compile-prog c++ ${BT_FLAGS_CPP} ${BT_FLAGS_CXX} \
	            -c ${.IMPSRC} -o ${.TARGET}

.cpp.o:
	@${BT_LOGIC} compile-prog c++ ${BT_FLAGS_CPP} ${BT_FLAGS_CXX} \
	            -c ${.IMPSRC} -o ${.TARGET}

# --------------------------------------------------------------------
# Main targets
# --------------------------------------------------------------------

# Set default sources, if appropiate.
.if defined(BT_PROG)
BT_SRCS?=	${BT_PROG}.c
BT_MAN?=	${BT_PROG}.1
.endif

# Determine object files.
.if !empty(BT_SRCS:N*.h)
BT_OBJS+=	${BT_SRCS:N*.h:R:S/$/.o/g}
.endif

# If we have object files, set program's build.
.if defined(BT_OBJS) && !empty(BT_OBJS)
.NOPATH: ${BT_OBJS} ${BT_PROG} ${BT_SRCS:C/\..$/.c/}

# The program target itself. Set a default link if not already
# defined.
${BT_PROG}: ${BT_OBJS}
.if !commands(${BT_PROG})
.if !empty(BT_SRCS:M*.cc) || !empty(BT_SRCS:M*.cpp)
	@${BT_LOGIC} link-prog c++ ${BT_FLAGS_LD} -o ${.TARGET} \
	            ${BT_OBJS} ${BT_LIBS}
.else
	@${BT_LOGIC} link-prog cc ${BT_FLAGS_LD} -o ${.TARGET} \
	            ${BT_OBJS} ${BT_LIBS}
.endif
.endif

.endif	# defined(BT_OBJS) && !empty(BT_OBJS)

real-all: depend ${BT_PROG}

BT_FILES_CLEAN+= a.out [Ee]rrs mklog core *.core ${BT_PROG} ${BT_OBJS}

# --------------------------------------------------------------------
# Installation
# --------------------------------------------------------------------

# Only install if possible.
.if defined(BT_PROG) && !target(_proginstall)

_proginstall:: ${BT_DIR_BIN}/${BT_PROG}
.PRECIOUS: ${BT_DIR_BIN}/${BT_PROG}

__proginstall: .USE
.if !exists(${BT_DIR_BIN})
	@${BT_INSTALL_DIR} ${BT_DIR_BIN}
.endif
	@${BT_INSTALL_BIN} ${.ALLSRC} ${.TARGET}

${BT_DIR_BIN}/${BT_PROG}! ${BT_PROG} __proginstall

.endif # defined(BT_PROG) && !target(_proginstall)

# Define an emtpy target, if needed.
.if !target(_proginstall)
_proginstall::
.endif

# --------------------------------------------------------------------
# Deinstallation
# --------------------------------------------------------------------

.if defined(BT_PROG) && !target(_progdeinstall)
_progdeinstall::
.if exists(${BT_DIR_BIN}/${BT_PROG})
	rm -f ${BT_DIR_BIN}/${BT_PROG}
.endif
.endif

# Define an emtpy target, if needed.
.if !target(_progdeinstall)
progdeinstall::
.endif

# Related stuff
.include <bt.man.mk>
.include <bt.dep.mk>
.include <bt.clean.mk>

${BT_TARGETS}:	# ensure existence
