#	$Id: bt.subdir.mk,v 1.5 2002/09/09 16:45:42 jmmv Exp $
#	$NetBSD: bsd.subdir.mk,v 1.46 2001/11/02 05:21:51 tv Exp $
#	@(#)bsd.subdir.mk	8.1 (Berkeley) 6/8/93

.include <bt.init.mk>

# Determine if there are specific subdirectories for our arch. Set
# ${__REAL_SUBDIR} to the list of real subdirs to build (i.e., can
# contian machine suffixes).
.for _dir in ${BT_SUBDIR}
.if exists(${_dir}.${MACHINE})
__REAL_SUBDIR+=${_dir}.${MACHINE}
.else
__REAL_SUBDIR+=${_dir}
.endif
.endfor

# Internal target for recursion.
__recurse: .USE
	@targ=${.TARGET:C/-.*$//};dir=${.TARGET:C/^[^-]*-//};		\
	case "$$dir" in /*)						\
		echo "$$targ ===> $$dir";				\
		cd "$$dir";						\
		${MAKE} "_THISDIR_=$$dir/" $$targ;			\
		;;							\
	*)								\
		echo "$$targ ===> ${_THISDIR_}$$dir";			\
		cd "${.CURDIR}/$$dir";					\
		${MAKE} "_THISDIR_=${_THISDIR_}$$dir/" $$targ;		\
		;;							\
	esac

# If we are making "cleandir", avoid the "clean" step.
.if make(cleandir)
__RECURSETARG=	${BT_TARGETS:Nclean}
clean:
.else
__RECURSETARG=	${BT_TARGETS}
.endif

# The top directory (where buildtool.d lives) needs some cleanup when
# making "cleandir".
.PHONY: cleandir-top
cleandir-top:
.if !empty(BT_FILES_CLEANDIRTOP)
.if ${BT_TOPDIR} == ${PWD}
	@echo "cleandir ===> (top directory)"
	rm -f ${BT_FILES_CLEANDIRTOP}
.endif
.endif

# For obscure reasons, we can't do a simple .if ${_dir} == ".WAIT"
# but have to assign to __TARGDIR first.
.for _targ in ${__RECURSETARG}
.for _dir in ${__REAL_SUBDIR}
__TARGDIR := ${_dir}
.if ${__TARGDIR} == ".WAIT"
BT_SUBDIR_${_targ} += .WAIT
.elif !commands(${_targ}-${_dir})
.PHONY: ${_targ}-${_dir}
${_targ}-${_dir}: .MAKE __recurse
BT_SUBDIR_${_targ} += ${_targ}-${_dir}
.endif
.endfor
.if defined(__REAL_SUBDIR)
.PHONY: subdir-${_targ}
subdir-${_targ}: ${BT_SUBDIR_${_targ}} ${_targ}-top
.if !target(${_targ}-top)
.PHONY: ${_targ}-top
${_targ}-top:
.endif
${_targ}: subdir-${_targ}
.endif
.endfor

${BT_TARGETS}:	# ensure existence
