#	$Id: bt.info.mk,v 1.5 2002/09/09 16:45:42 jmmv Exp $
#	$NetBSD: bsd.info.mk,v 1.26 2002/03/01 15:42:10 pk Exp $

.include <bt.init.mk>

.SUFFIXES: .txi .texi .texinfo .info

# --------------------------------------------------------------------
# Basic targets
# --------------------------------------------------------------------

.PHONY:		_infoinstall _infodeinstall
real-install:	_infoinstall
real-deinstall:	_infodeinstall

# Set some reasonable defaults.
BT_PROG_MAKEINFO?=	makeinfo
BT_PROG_INSTALLINFO?=	install-info
BT_FLAGS_INFO?=		--no-split

# --------------------------------------------------------------------
# Build
# --------------------------------------------------------------------

_INFOFILES=	${BT_TEXINFO:C/\.te?xi(nfo)?$/.info/}

real-all:	${_INFOFILES}
.NOPATH:	${_INFOFILES}

.txi.info .texi.info .texinfo.info:
	${BT_PROG_MAKEINFO} ${BT_FLAGS_INFO} -o $@ $<

BT_FILES_CLEAN+= ${_INFOFILES}

# --------------------------------------------------------------------
# Installation
# --------------------------------------------------------------------

_infoinstall::	# ensure existence

_DIRFILE=${BT_DIR_INFO}/dir
_INSTINFO=

# serialize access to ${_DIRFILE}; needed for parallel makes
__infoinstall: .USE
.if !exists(${BT_DIR_INFO})
	${BT_INSTALL_DIR} ${BT_DIR_INFO}
.endif
	${BT_INSTALL_DATA} ${.ALLSRC} ${.TARGET}
	${BT_PROG_INSTALLINFO} -d ${_DIRFILE} -r ${.TARGET} 2>/dev/null
	${BT_PROG_INSTALLINFO} -d ${_DIRFILE} ${.TARGET}

.for _F in ${_INFOFILES:O:u}

${BT_DIR_INFO}/${_F}!	${_F} __infoinstall

_infoinstall::	${BT_DIR_INFO}/${_F}
_INSTINFO+=	${BT_DIR_INFO}/${_F}
.PRECIOUS:	${BT_DIR_INFO}/${_F}	# keep if install fails
.endfor

# --------------------------------------------------------------------
# Deinstallation
# --------------------------------------------------------------------

_infodeinstall::
.for _F in ${_INSTINFO}
.if exists(${_F})
	@iname=`basename ${_F}`; \
	echo ${BT_PROG_INSTALLINFO} -d ${_DIRFILE} --delete $$iname; \
	${BT_PROG_INSTALLINFO} -d ${_DIRFILE} --delete $$iname
	rm -f ${_F}
.endif
.endfor

${TARGETS}:	# ensure existence

.include <bt.clean.mk>