#!/usr/bin/perl
#  invest.pl - an extremely simple hack to help me keep track of my
#              investments.
#
#  Written by Curtis Olson.  Started September 1, 1995.
#
#  Copyright (C) 1995 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  The format of an input file would be something like the following.
#  Note, fields should separated by one or more tabs.
#
# -------------------------------------------------------------------
# | # Date          Description             Shares  Unit Price
# | #-----          -----------             ------  ----------
# | #19960101       Beginning of 1996       99.265  52.18
# | #19960201       Updated value           0.000   52.66
# -------------------------------------------------------------------
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: invest.pl,v 1.1.1.1 1999/12/18 02:06:03 curt Exp $
# (Log is kept at end of this file)


$total_shares = 0;
$total_invest = 0;
$acct_value = 0;

print "                                        Price   Total\n";
print "                                New     per     Shares  Total   Total\n";
print "Date     Description            Shares  Share   Owned   Invstd  Value\n";
print "-------- ---------------------- ------  ------  ------  ------  ------\n";

while ( <> ) {
    chop($_);

    if ( m/^[ \t]*#/ ) {
	# toss the comment
    } else {
	($date, $desc, $shares, $price) = split(/\t+/, $_);
	if ( $shares < 25 ) {
	    $reinv = $shares * $price;
	    $invest = 0;
	} else {
	    $reinv = 0;
	    $invest = $shares * $price;
	}

	$total_shares += $shares;
	$total_invest += $reinv + $invest;
	$acct_value = $total_shares * $price;

        printf "%s %-22s\t%-7.3f\t%.2f\t%.3f\t%.2f\t%.2f\n", $date, $desc, 
		$shares, $price, $total_shares, $total_invest, $acct_value;
    }
}


# ----------------------------------------------------------------------------
# $Log: invest.pl,v $
# Revision 1.1.1.1  1999/12/18 02:06:03  curt
# Start of 0.8 branch
#
# Revision 1.1  1999/12/17 19:21:02  curt
# Added to repository.
#
# Revision 2.3  1999/11/21 00:48:02  curt
# Tweaks to copyright dates and email address.
#
# Revision 2.2  1996/07/13 02:58:23  curt
# Misc. changes.
#
# Revision 2.1  1996/02/27  05:36:03  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:12  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
