#!/usr/bin/perl
#  log.pl - logging functions
#
#  Written by Christopher Browne.  Started November 1, 1994.
#  Modified by Curtis Olson.
#
#  Copyright (C) 1994  Christopher B. Browne cbrowne@io.org
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: log.pl,v 1.2 2000/01/02 19:08:02 curt Exp $


package CBB;

use strict;   # don't take no guff


# Create a log entry
sub log_txn {
    my($command_line) = @_;
    my($home) = &file_dirname($CBB::current_file);

    print DEBUG "File is $CBB::current_file\n" if $CBB::debug;
    print DEBUG "logging to $home/alltxns.log\n" if $CBB::debug;

    open(LOG, ">>$home/alltxns.log");
    print LOG &log_fmt_date() . " " . $command_line . "\n";
    close(LOG);

}


# return the current date/time in log format
sub log_fmt_date {
    my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) 
	= localtime(time);
    $year += 1900;

    return sprintf("%04d/%02d/%02d %02d:%02d:%02d", $year, $mon+1,
		   $mday, $hour, $min, $sec);
}


1;				# need to return a true value
