#!wish8.2 -f
#  'CBB' -- Check Book Balancer
#
#  menu.tcl -- menu management routines.
#
#  Written by Curtis Olson.  Started August 25, 1994.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: menu.tcl,v 1.1.1.1 1999/12/18 02:05:25 curt Exp $


proc setup_menubar m {
    global cbb words

    menubutton $m.file -text $words(file) -underline 0 -menu $m.file.menu \
	    -takefocus 0
    menubutton $m.edit -text $words(edit) -underline 1 -menu $m.edit.menu \
	    -takefocus 0
    menubutton $m.functions -text $words(functions) -menu $m.functions.menu \
	    -takefocus 0
    menubutton $m.extern -text $words(external) -underline 1 -menu $m.extern.menu \
	    -takefocus 0
    if { $cbb(devel) == 1 } {
	menubutton $m.devel -text $words(devel) -menu $m.devel.menu \
		-takefocus 0
    }
    menubutton $m.help -text $words(help) -underline 0 -menu $m.help.menu \
	    -takefocus 0
    
    if { $cbb(devel) == 0 } {
	pack $m.file $m.edit $m.functions $m.extern -side left -ipadx 2
    } else {
	pack $m.file $m.edit $m.functions $m.extern $m.devel -side left -ipadx 2
    }
    pack $m.help -side right -ipadx 1
}


proc setup_file_menu m {
    global words

    set mf $m.file.menu

    if { [winfo exists $mf] } {
	destroy $mf
    }

    menu $mf -tearoff 0

    $mf add command -label $words(newfile) -underline 0 \
	    -command { acctNew }
    $mf add command -label $words(load) -underline 0 \
    	    -command { acctLoad }
    $mf add command -label $words(save) -underline 0 \
            -command { 
		if { $cbb(cur_file) != "noname.cbb" } {
		    acctSave
		} else {
		    acctSaveAs
		}
	    }
    .menubar.file.menu add command -label $words(saveas) -underline 5 \
            -command { acctSaveAs }

    $mf add separator

    $mf add command -label $words(importqif) -underline 0 \
	    -command {
		set import_type 1
		acctImport
	    }
    $mf add command -label $words(exportqif) -underline 0 \
	    -command { acctExportQIF }

    $mf add separator

    $mf add cascade -label $words(prefs) -underline 0 -menu $mf.prefs

    $mf add separator

    $mf add command -label $words(quit) -underline 0 -command { cbbQuit }
    $mf entryconfig 10 -accelerator <Meta-Q>
    bind all <Meta-q> { cbbQuit }
    bind all <Alt-q> { cbbQuit }
}


proc setup_edit_menu m {
    global words

    set me $m.edit.menu

    menu $me -tearoff 0

    $me add command -label $words(undo) -underline 0 -command { undoAction }
    $me entryconfig 0 -accelerator <Meta-U>
    bind all <Meta-u> { undoAction }
    bind all <Alt-u> { undoAction }

    $me add separator

    $me add command -label $words(newtrans) \
	    -underline 0 -command { clear_entry_area }
    $me entryconfig 2 -accelerator <Meta-N>
    bind all <Meta-n> { clear_entry_area }
    bind all <Alt-n> { clear_entry_area }

    $me add command -label $words(edittrans) -underline 0 \
	    -command { 
	if { [listGetCurTrans] >= 1 } {
	    update_entry_area [listGetCurTrans].0
	}
    }
    $me entryconfig 3 -accelerator <Meta-E>
    bind all <Meta-e> { 
	if { [listGetCurTrans] >= 1 } {
	    update_entry_area [listGetCurTrans].0
	}
    }
    bind all <Alt-e> { 
	if { [listGetCurTrans] >= 1 } {
	    update_entry_area [listGetCurTrans].0
	}
    }

    $me add command -label $words(delete) -underline 0 \
	    -command { 
	if { "[.trans.list tag nextrange sel 1.0 end ]" != "" } {
	    delete_trans [.trans.list tag nextrange sel 1.0 end ]
	}
    }

    $me add separator

    $me add command -label $words(splits) -underline 0 \
	    -command { 
	cbbWindow.splits
	tkwait window .splits
    }
    $me entryconfig 6 -accelerator <Meta-S>
    bind all <Meta-s> { 
	cbbWindow.splits
	tkwait window .splits
    }
    bind all <Alt-s> { 
	cbbWindow.splits
	tkwait window .splits
    }
}


proc setup_functions_menu m {
    global cbb words

    set mf $m.functions.menu

    menu $mf -tearoff 0

    $mf add cascade -label $words(goto) -underline 0 -menu $mf.goto

    $mf add separator

    $mf add command -label $words(catlist) \
	    -underline 0 -command { cbbWindow.catwin }
    $mf entryconfig 0 -accelerator <Meta-C>
    bind all <Meta-c> { cbbWindow.catwin }
    bind all <Alt-c> { cbbWindow.catwin }

    $mf add command -label $words(defaultcats) \
	    -underline 0 -command { catImportDefaults }

    $mf add separator

    $mf add command -label $words(balance) -underline 0 -command { balance }

    $mf add separator

    $mf add command -label $words(reports) -underline 0 -command { 
	set report(type) "report"
	set report(cur_file) $cbb(cur_file)
	set report(tmp_file) "/tmp/cbb-tmp-[pid].cbb"

	if { $cbb(debug) } { 
	    puts "Temp file is $report(tmp_file) -- saving ..."
	}
	# tell engine to save transactions
	puts $eng "auto_save_trans $report(tmp_file)"; flush $eng
	if { $cbb(debug) } { puts "No result should be returned." }

	cbbWindow.rep
    }

    $mf add command -label $words(graphs) -underline 0 -command { 
	set report(type) "graph"
	set report(cur_file) $cbb(cur_file)
	set report(tmp_file) "/tmp/cbb-tmp-[pid].cbb"

	if { $cbb(debug) } { 
	    puts "Temp file is $report(tmp_file) -- saving ..."
	}
	# tell engine to save transactions
	puts $eng "auto_save_trans $report(tmp_file)"; flush $eng
	if { $cbb(debug) } { puts "No result should be returned." }

	cbbWindow.rep
    }
}


proc setup_extern_menu m {
    global lib_path

    set me $m.extern.menu

    menu $me -tearoff 0

    set filehandle [open "$lib_path/extern.conf" r]
    while { [gets $filehandle line] >= 0 } {
	if { "[string range $line 0 0]" == "-" } {
            $me add separator
	} elseif { "[string range $line 0 0]" == "#" } {
	    # ignore this line
	} elseif { [string length $line] < 3  } {
	    # ignore this line
        } else {
	    set pieces [split $line "\t"]
	    set name [lindex $pieces 0]
	    set prog [lindex $pieces 1]
            $me add command -label $name -command "launch_extern \"$prog\""
	}
    }
    close $filehandle
}


proc launch_extern { prog } {
    global report cbb eng

    if { $cbb(safe_mode) == 1 } {
        cbbWindow.ok "Cannot launch external scripts when running in 'safe' \
		mode." 
	tkwait window .ok
        return
    }

    set report(tmp_file) "/tmp/cbb-tmp-[pid].cbb"
    if { $cbb(debug) } { puts "Temp file is $report(tmp_file) -- saving ..." }
    # tell engine to save transactions
    puts $eng "auto_save_trans $report(tmp_file)"; flush $eng
    if { $cbb(debug) } { puts "No result should be returned." }

    regsub -all "%a" $prog $cbb(cur_file) prog
    regsub -all "%t" $prog $report(tmp_file) prog

    if { $cbb(debug) } { puts "exec $prog &" }
    eval exec $prog &
}


proc setup_devel_menu m {
    set mf $m.devel.menu

    if { [winfo exists $mf] } {
	destroy $mf
    }

    menu $mf -tearoff 0

    $mf add command -label "Re-source \"balance.tcl\""  \
	    -command {  source "$lib_path/balance.tcl" }
    $mf add command -label "Re-source \"bindings.tcl\""  \
	    -command {  source "$lib_path/bindings.tcl" }
    $mf add command -label "Re-source \"categories.tcl\""  \
	    -command {  source "$lib_path/categories.tcl" }
    $mf add command -label "Re-source \"common.tcl\""  \
	    -command {  source "$lib_path/common.tcl" }
    $mf add command -label "Re-source \"file.tcl\""  \
	    -command {  source "$lib_path/file.tcl" }
    $mf add command -label "Re-source \"filebox.tcl\""  \
	    -command {  source "$lib_path/filebox.tcl" }
    $mf add command -label "Re-source \"help.tcl\""  \
	    -command {  source "$lib_path/help.tcl" }
    $mf add command -label "Re-source \"init.tcl\""  \
	    -command {  source "$lib_path/init.tcl" }
    $mf add command -label "Re-source \"main.tcl\""  \
	    -command {  source "$lib_path/main.tcl" }
    $mf add command -label "Re-source \"menu.tcl\""  \
	    -command {  source "$lib_path/menu.tcl" }
    $mf add command -label "Re-source \"prefs.tcl\""  \
	    -command {  source "$lib_path/prefs.tcl" }
    $mf add command -label "Re-source \"reports.tcl\""  \
	    -command {  source "$lib_path/reports.tcl" }
    $mf add command -label "Re-source \"splits.tcl\""  \
	    -command {  source "$lib_path/splits.tcl" }
    $mf add command -label "Re-source \"undo.tcl\""  \
	    -command {  source "$lib_path/undo.tcl" }
}


proc setup_help_menu m {
    global cbb words argv0 libpath

    set mh $m.help.menu
    menu $mh -tearoff 0

    $mh add command -label "$words(about) [file tail $argv0] ..." \
	    -underline 0 -command { cbbWindow.aboutwin [file tail $argv0] }

    $mh add separator

    $mh add command -label $words(htmlman) -underline 0 -command {
	if { $cbb(safe_mode) == 0 } {
	    if { $cbb(web_browser) == "netscape" } {
		# ... so they want to use nutscape ...
		if [catch {exec xwininfo -name "Netscape"} data] {
		    # no existing netscape running
		    exec $cbb(web_browser) $lib_path/docs/cbb-man/cbb-man.html &
		} else {
		    # A running copy of netscape exists
		    exec $cbb(web_browser) -remote \
			    openURL($lib_path/docs/cbb-man/cbb-man.html) &
		}
	    } elseif { $cbb(web_browser) == "lynx" } {
		exec xterm -sb -e $cbb(web_browser) \
			$lib_path/docs/cbb-man/cbb-man.html &
	    } else {
		exec $cbb(web_browser) $lib_path/docs/cbb-man/cbb-man.html &
	    }
	} else {
	    cbbWindow.ok "The online manual can be read from the CBB web page \
		    at: http://www.menet.umn.edu/~curt/cbb/"
	    tkwait window .ok
	}
    }

    $mh add command -label $words(textman) -command { 
	cbbWindow.helpwin
    }
}


proc setup_file_prefs_menu m {
    global words

    set mfp $m.file.menu.prefs

    menu $mfp -tearoff 0

    $mfp add checkbutton -label $words(usemems) \
	    -variable cbb(use_mems) -command {
	set cbb(pref_chg) 1
    }

    $mfp add checkbutton -label $words(usestartdate) \
	    -variable cbb(use_sdate) -command {
	set cbb(pref_chg) 1
    }

    $mfp add checkbutton -label $words(usecache) \
	    -variable cbb(cache) -command {
	set cbb(pref_chg) 1

	puts $eng "cache $cbb(cache)"; flush $eng;
	gets $eng result;
    }

    $mfp add separator

    $mfp add command -label $words(setstartdate) -command { 
	setStartDate
    }

    $mfp add separator

    $mfp add cascade -label $words(appearance) -menu $mfp.appear

    $mfp add cascade -label $words(crypto) -menu $mfp.crypt

    $mfp add cascade -label $words(dups) -menu $mfp.duplicate

    $mfp add separator

    $mfp add command -label $words(saveprefs) -command {
	cbbrcSave
    }

}

proc setup_prefs_appear_menu m {
    global words

    set mfpa $m.file.menu.prefs.appear

    menu $mfpa -tearoff 0

    $mfpa add checkbutton -label $words(balloon) \
	    -variable cbb(balloon,on) -command {
	set cbb(pref_chg) 1
    }

    $mfpa add checkbutton -label $words(autohilite) \
	    -variable cbb(auto_hilite) -command {
	set cbb(pref_chg) 1
	if { $cbb(auto_hilite) } {
		setup_auto_hilite
	} else {
		bind Entry <FocusIn> {}
		bind Entry <FocusOut> {}
	}
    }

    $mfpa add checkbutton -label $words(datefmt) \
	-variable cbb(date_fmt) -onvalue 1 -offvalue 2 -command {
	set cbb(pref_chg) 1
    }

    $mfpa add separator

    $mfpa add command -label $words(dimensions) -command {
	setDimensions
    }
}

proc setup_prefs_crypt_menu m {
    global words

    set mfpc $m.file.menu.prefs.crypt

    menu $mfpc -tearoff 0

    $mfpc add checkbutton -label $words(usecrypto) \
	    -variable cbb(use_crypt) -command {
	useCrypt
    }

    $mfpc add separator

    $mfpc add command -label $words(setcode) -command {
	setCryptCode
    }

    $mfpc add command -label $words(cryptoprog) -command {
	setCryptProgram
    }

}

proc setup_prefs_duplicate_menu m {
    global cbb words

    set mfpd $m.file.menu.prefs.duplicate

    menu $mfpd -tearoff 0

    $mfpd add command -label $words(duplicatewarn)

    $mfpd add separator

    $mfpd add radio -label $words(alwaysinsert) \
	    -variable cbb(duplicate) -value 0 -command {
	set cbb(pref_chg) 1

	puts $eng "duplicate $cbb(duplicate)"; flush $eng;
	gets $eng result;
    }

    $mfpd add radio -label $words(neverinsert) \
	    -variable cbb(duplicate) -value 1 -command {
	set cbb(pref_chg) 1

	puts $eng "duplicate $cbb(duplicate)"; flush $eng;
	gets $eng result;
    }

    $mfpd add radio -label $words(askme) \
	    -variable cbb(duplicate) -value 2 -command {
	set cbb(pref_chg) 1

	puts $eng "duplicate $cbb(duplicate)"; flush $eng;
	gets $eng result;
    }

    $mfpd add separator

    $mfpd add command -label $words(selectfields) -command {
	setFields
    }
}

proc setup_functions_goto_menu m {
    global words

    set mfg $m.functions.menu.goto

    menu $mfg -tearoff 0

    $mfg add command -label $words(gohome) -underline 0 -command { goto 0 }
    $mfg entryconfig 0 -accelerator <Meta-Home>
    $mfg add command -label $words(gotoday) -underline 0 -command { 
	puts $eng "raw_date"; flush $eng
	gets $eng tmpdate
	goto [find_index_from_date $tmpdate] 
    }
    $mfg add command -label $words(goend) -underline 0 -command { 
	goto [expr [listGetSize] - 1]
    }
    $mfg entryconfig 2 -accelerator <Meta-End>

    $mfg add separator

    $mfg add command -label $words(gopgup) -underline 5 \
     	    -command {
	goto [expr [.trans.list curselection] - ($cbb(list_height) - 4)]
    }
    $mfg entryconfig 4 -accelerator <Prior>
    $mfg add command -label $words(gopgdn) -underline 5 \
     	    -command { 
	goto [expr [.trans.list curselection] + ($cbb(list_height) - 4)]
    }
    $mfg entryconfig 5 -accelerator <Next>

    $mfg add separator

    $mfg add command -label $words(goup) -underline 1 \
     	    -command {
	goto [expr [.trans.list curselection] - 2]
    }
    $mfg entryconfig 7 -accelerator <Up>
    $mfg add command -label $words(godown) -underline 1 \
     	    -command { 
	goto [expr [.trans.list curselection] + 2]
    }
    $mfg entryconfig 8 -accelerator <Down>
}
