#!/usr/bin/perl
#  rep-txn-list.pl - Prints a report of the transactions sorted by date
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: txn-list.pl,v 1.1.1.1 1999/12/18 02:07:11 curt Exp $


package CBB;

use strict;    # don't take no guff


my($cbb_incl_dir, $temp);
my($account, @account_list, $name, $key, $trans, %ALLTRANS);
my($gtotal, $junk, $result);
my($date_fmt, $date, $todate, $fromdate);

# specify the installed location of the necessary pieces.
BEGIN{
$CBB::cbb_incl_dir = "/usr/local/lib/cbb";
  unshift(@INC, $CBB::cbb_incl_dir);
}

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || 
    die "Usage: report [ -from mm/dd/[yy]yy ] [ -to mm/dd/[yy]yy ] accounts";


# process arguments

($date_fmt, $fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $trans) = split(/\t/, $result, 2);
        ($date, $junk) = split(/\t/, $trans, 2);

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {
	    $ALLTRANS{"$key$name"} = $trans;
        }

        $result = &next_trans();
    }
}

# sort and print
foreach $key (sort (keys %ALLTRANS) ) {
    # print $ALLTRANS{$key} . "\n";
    &format_line("$ALLTRANS{$key}");
}


$gtotal = 0.00;

sub format_line {
    my($date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
          $total) = split(/\t/, $_[0]);
    my($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    my($nicedate, $cutdesc, $cutcom, $nicecat);

    $year = substr($year, 2, 4);

    if ( $date_fmt == 1 ) {
	$nicedate = "$mon/$day/$year";
    } else {
	$nicedate = "$day.$mon.$year";
    }
    $cutdesc = substr($desc, 0, 15);
    $cutcom = substr($com, 0, 15);
    $nicecat = substr($cat, 0, 9);
    if ( substr($cat, 0, 1) eq "|" ) {
        $nicecat = "-Splits-";
    }

    $gtotal += $credit - $debit;

    printf("%5s  %-8s  %-15s  %9.2f  %9.2f  %-1s  %9.2f\n",
          $check, $nicedate, $cutdesc, $debit, $credit, $cleared, $gtotal);
    printf("%5s  %-8s  %-15s  %-9s\n\n", "", "", $cutcom, $nicecat);
}
