;;; win32-cursor.el --  Specify current input mode: In WindowsIME or out of WindowsIME.

;; Author: Hiroshi YOKOTA <y5t0964@students.chiba-u.ac.jp>
;; Maintainer: Hiroshi YOKOTA <y5t0964@students.chiba-u.ac.jp>
;; Version: 1.0
;; Keywords: win32 ime color color-mate kanakan-cursor
;; Content-Type: text/plain; charset=x-euc-jp

;; This code is derived from leim-cursor.el.

;;; This program is distributed under the GNU GENERAL PUBLIC LICENSE.

;;; History:
;; win32-cursor.el for Color-Mate Ver.1.0:
;;    o Initial version.

;;;; Usage
;;; Put this file in emacs-lisp directory.
;;; And put (require 'win32-cursor) in your .emacs.

;;;; Note
;;; This code will work with "Mule for Win32" running on window system.
;;; If you want to change the color for each input mode into "yellow",
;;; put (setq leim-mode-on-cursor-color "yellow") in your .emacs.

;---------------------------------------------------------------;
;                 win32-cursor.el for Color-Mate
;---------------------------------------------------------------;
; $Id: win32-cursor.el,v 1.3 2001/03/06 00:58:03 elca Exp $

;;;; Code

;; Color Setup
(defvar win32-ime-mode-on-cursor-color "forestgreen"
  "Cursor color for leim mode")
(defvar win32-ime-mode-off-cursor-color nil
  "Cursor color for mode out of leim")

(defvar win32-ime-cursor-color-bound-to-each-buffer nil
  "This variable will be referred when buffer is selected.
This is win32-cursor's buffer-local variable. Don't use it!")
(make-variable-buffer-local 'win32-cursor-color-bound-to-each-buffer)


;; ̵꤬ϽΥ뿧Ѥ
(if (not win32-ime-mode-off-cursor-color)
    (setq win32-ime-mode-off-cursor-color
	  (cdr (assoc 'cursor-color (frame-parameters (selected-frame))))
	  ))

;;
;; ¾ kanakan-cursor ץȤϢѤѿ
;;
(defvar skk-cursor-japanese-mode "init" "If \"on\", you are input words with skk.")
(defvar win32-ime-cursor-mode    "init" "If \"on\", you are input words with Win32 IME")
(make-variable-buffer-local 'skk-cursor-japanese-mode)
(make-variable-buffer-local 'win32-ime-cursor-mode)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; "C-\\" 򲡤˸ƤФ롣
;;
(add-hook 'win32-ime-on-hook
	 '(lambda ()
	    (progn
	      (setq win32-ime-cursor-color-bound-to-each-buffer
		    win32-ime-mode-on-cursor-color)
	      (win32-ime-cursor-set "on"))))
(add-hook 'win32-ime-off-hook
	 '(lambda ()
	    (progn
	      (setq win32-ime-cursor-color-bound-to-each-buffer
		    win32-ime-mode-off-cursor-color)
	      (win32-ime-cursor-set "off"))))


(defadvice bury-buffer (after add-win32-ime-cursor-set first activate)
  (win32-ime-cursor-set win32-ime-cursor-mode))
(defadvice kill-buffer (after add-win32-ime-cursor-set first activate)
  (win32-ime-cursor-set win32-ime-cursor-mode))
(defadvice switch-to-buffer (after add-win32-ime-cursor-set first activate)
  (win32-ime-cursor-set win32-ime-cursor-mode))
(defadvice select-window (after add-win32-ime-cursor-set first activate)
  (win32-ime-cursor-set win32-ime-cursor-mode))
(defadvice other-window (after add-win32-ime-cursor-set first activate)
  (win32-ime-cursor-set win32-ime-cursor-mode))

(add-hook 'after-make-frame-functions
	  (function
	   (lambda (nframe)
	     (select-frame nframe)
	     (win32-ime-cursor-set win32-ime-cursor-mode))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; 뿧
;; set cursor color
;;
;; skk δϥ⡼ɤ on  ʤäƤȥ뿧򸵤᤹
;; ʤʤ褦ˤƤ롣
;;
(defun win32-ime-cursor-set (mode)
  "Cursor color changer with conflict management."
  (progn
    (cond
     ((equal mode "on")
      (progn
	(set-cursor-color win32-ime-cursor-color-bound-to-each-buffer)
	(setq win32-ime-cursor-mode "on")
	))
     ((equal mode "off")
      (if (not (equal skk-cursor-japanese-mode "on"))
	  (progn
	    (set-cursor-color win32-ime-cursor-color-bound-to-each-buffer)
	    (setq win32-ime-cursor-mode "off")
	    )))
     ((equal mode "init")
      (if (not (equal skk-cursor-japanese-mode "on"))
	  (progn
	    (set-cursor-color win32-ime-mode-off-cursor-color)
	    (setq win32-ime-cursor-mode "init")
	    )))
     )))

(provide 'win32-cursor)

;;; win32-cursor.el ends here
