/*
**  CXSC is a C++ library for eXtended Scientific Computing
**
**  Copyright (C) 1990-2000 Institut fuer Angewandte Mathematik,
**                          Universitaet Karlsruhe, Germany
**            (C) 2000-2001 Wiss. Rechnen/Softwaretechnologie
**                          Universitaet Wuppertal, Germany   
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* CVS $Id: complex.inl,v 1.3 2001/08/09 11:37:54 cxsc Exp $ */

namespace cxsc {

// ---- Constructors ----------------------------------------------

inline complex & complex::operator= (const real & r) throw()
{
   re=r;im=0;
   return *this;
}

      // ---- Std.Operators ---------------------------------------
inline complex operator -(const complex &a) throw () 
{
   return complex(-a.re,-a.im);
}

inline complex operator +(const complex &a) throw ()
{
   return a;
}

inline complex operator +(const complex &a,const complex &b) throw()
{
   return complex(a.re+b.re,a.im+b.im);
}

inline complex operator -(const complex &a,const complex &b) throw()
{
   return complex(a.re-b.re,a.im-b.im);
}

inline complex & operator +=(complex &a, const complex &b) throw() { return a=a+b; }
inline complex & operator -=(complex &a, const complex &b) throw() { return a=a-b; }
inline complex & operator *=(complex &a, const complex &b) throw() { return a=a*b; }
inline complex & operator /=(complex &a, const complex &b) throw() { return a=a/b; }

inline complex operator +(const complex & a,const real & b) throw() 
{ 
   return complex(a.re+b,a.im);
}

inline complex operator +(const real & a,const complex & b) throw()
{
   return complex(a+b.re,b.im);
}

inline complex operator -(const complex & a,const real & b) throw()
{
   return complex(a.re-b,a.im);
}

inline complex operator -(const real & a,const complex & b) throw()
{
   return complex(a-b.re,-b.im);
}

inline complex operator *(const complex & a,const real & b) throw()
{
   return a*_complex(b);
}

inline complex operator *(const real & a,const complex & b) throw()
{
   return _complex(a)*b;
}

inline complex operator /(const complex & a,const real & b) throw()
{
   return a/_complex(b);
}

inline complex operator /(const real & a,const complex & b) throw()
{
   return _complex(a)/b;
}

inline complex & operator +=(complex & a, const real & b) throw() { return a=a+b; }
inline complex & operator -=(complex & a, const real & b) throw() { return a=a-b; }
inline complex & operator *=(complex & a, const real & b) throw() { return a=a*b; }
inline complex & operator /=(complex & a, const real & b) throw() { return a=a/b; }

      // ---- Comp.Operat.  ---------------------------------------
inline bool operator!  (const complex & a)                    throw() { return !a.re && !a.im; }
inline bool operator== (const complex & a, const complex & b) throw() { return a.re==b.re && a.im==b.im; }
inline bool operator!= (const complex & a, const complex & b) throw() { return a.re!=b.re || a.im!=b.im; }
inline bool operator== (const complex & a, const real & b)    throw() { return !a.im && a.re==b; }
inline bool operator== (const real & a, const complex & b)    throw() { return !b.im && a==b.re; }
inline bool operator!= (const complex & a, const real & b)    throw() { return !!a.im || a.re!=b; }
inline bool operator!= (const real & a, const complex & b)    throw() { return !!b.im || a!=b.re; }

      // ---- Others   -------------------------------------------

inline complex conj(const complex & a) throw() { return complex(a.re,-a.im); }

} // namespace cxsc
