/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	AudioClipNode.h
*
******************************************************************/

#ifndef _AUDIOCLLIP_H_
#define _AUDIOCLLIP_H_

#include "vrmlfields.h"
#include "Node.h"

#define isPlayingPrivateFieldName		"isPlaying"

class AudioClipNode : public Node {

	double	mCurrentTime;

public:

	AudioClipNode();
	~AudioClipNode();

	////////////////////////////////////////////////
	//	Description
	////////////////////////////////////////////////

	void setDescription(String value);
	String getDescription();

	////////////////////////////////////////////////
	//	Loop
	////////////////////////////////////////////////
	
	void setLoop(bool value);
	void setLoop(int value);
	bool getLoop();
	bool isLoop();

	////////////////////////////////////////////////
	//	Pitch
	////////////////////////////////////////////////
	
	void setPitch(float value);
	float getPitch();

	////////////////////////////////////////////////
	//	Start time
	////////////////////////////////////////////////
	
	void setStartTime(double value);
	double getStartTime();

	////////////////////////////////////////////////
	//	Stop time
	////////////////////////////////////////////////
	
	void setStopTime(double value);
	double getStopTime();

	////////////////////////////////////////////////
	//	isActive
	////////////////////////////////////////////////
	
	void setIsActive(bool  value);
	bool  getIsActive();
	bool  isActive();
	Field *getIsActiveField();

	////////////////////////////////////////////////
	//	duration_changed
	////////////////////////////////////////////////
	
	void setDurationChanged(double value);
	double getDurationChanged();

	////////////////////////////////////////////////
	// Url
	////////////////////////////////////////////////

	void addUrl(String value);
	int getNUrls();
	String getUrl(int index);
	void setUrl(int index, char *urlString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	AudioClipNode *next();
	AudioClipNode *nextTraversal();

	////////////////////////////////////////////////
	//	Virutual functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	Time
	////////////////////////////////////////////////

	void setCurrentTime(double time);
	double getCurrentTime();
};

#endif
