/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	CoordinateNode.h
*
******************************************************************/

#ifndef _COOORDINATE_H_
#define _COOORDINATE_H_

#include "vrmlfields.h"
#include "Node.h"

class CoordinateNode : public Node {

public:

	CoordinateNode();
	~CoordinateNode();

	////////////////////////////////////////////////
	//	point 
	////////////////////////////////////////////////

	void addPoint(float point[]);
	void addPoint(float x, float y, float z);
	int getNPoints();
	void getPoint(int index, float point[]);
	void setPoint(int index, float point[]);
	void setPoint(int index, float x, float y, float z);
	void removePoint(int index);
	void removeLastPoint();
	void removeFirstPoint();
	void removeAllPoints();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Output
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	CoordinateNode *next();
	CoordinateNode *nextTraversal();

};

#endif

