/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	LightNode.h
*
******************************************************************/

#ifndef _LIGHTNODE_H_
#define _LIGHTNODE_H_

#include "vrmlfields.h"
#include "Node.h"

class LightNode : public Node {
	
public:

	LightNode();
	virtual ~LightNode();

	////////////////////////////////////////////////
	//	On
	////////////////////////////////////////////////
	
	void setOn(bool on);
	void setOn(int value);
	bool isOn();

	////////////////////////////////////////////////
	//	Intensity
	////////////////////////////////////////////////
	
	void setIntensity(float value);
	float getIntensity();

	////////////////////////////////////////////////
	//	Color
	////////////////////////////////////////////////

	void setColor(float value[]);
	void setColor(float r, float g, float b);
	void getColor(float value[]);

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	virtual bool isChildNodeType(Node *node) = 0;

	virtual void initialize() = 0;

	virtual void uninitialize() = 0;

	virtual void update() = 0;

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	virtual void outputContext(ostream &printStream, String indentString) = 0;
};

#endif

