/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	LodNode.h
*
******************************************************************/

#ifndef _LOD_H_
#define _LOD_H_

#include "vrmlfields.h"
#include "Node.h"
#include "JVector.h"

class LodNode : public Node {

public:

	LodNode();
	~LodNode();
	
	////////////////////////////////////////////////
	//	center
	////////////////////////////////////////////////

	void setCenter(float value[]);
	void setCenter(float x, float y, float z);
	void getCenter(float value[]);

	////////////////////////////////////////////////
	//	range 
	////////////////////////////////////////////////

	void addRange(float value);
	int getNRanges();
	float getRange(int index);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	LodNode *next();
	LodNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

void UpdateLod(LodNode *lod);
void InitializeLod(LodNode *lod);
void UninitializeLod(LodNode *lod);

#endif

