/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	PlaneSensorNode.h
*
******************************************************************/

#ifndef _PLANESENSOR_H_
#define _PLANESENSOR_H_

#include "vrmlfields.h"
#include "Node.h"

class PlaneSensorNode : public Node {
	
public:

	PlaneSensorNode();
	~PlaneSensorNode();

	////////////////////////////////////////////////
	//	Enabled
	////////////////////////////////////////////////
	
	void setEnabled(bool  value);
	void setEnabled(int value);
	bool getEnabled();
	bool isEnabled();
	SFBool *getEnabledField();

	////////////////////////////////////////////////
	//	AutoOffset
	////////////////////////////////////////////////
	
	void setAutoOffset(bool value);
	void setAutoOffset(int value);
	bool getAutoOffset();
	bool  isAutoOffset();
	SFBool *getAutoOffsetField();

	////////////////////////////////////////////////
	//	MinPosition
	////////////////////////////////////////////////
	
	void setMinPosition(float value[]);
	void setMinPosition(float x, float y);
	void getMinPosition(float value[]);
	void getMinPosition(float *x, float *y);
	SFVec2f *getMinPositionField();

	////////////////////////////////////////////////
	//	MaxPosition
	////////////////////////////////////////////////
	
	void setMaxPosition(float value[]);
	void setMaxPosition(float x, float y);
	void getMaxPosition(float value[]);
	void getMaxPosition(float *x, float *y);
	SFVec2f *getMaxPositionField();

	////////////////////////////////////////////////
	//	Offset
	////////////////////////////////////////////////
	
	void setOffset(float value[]);
	void getOffset(float value[]);
	SFVec3f *getOffsetField();

	////////////////////////////////////////////////
	//	isActive
	////////////////////////////////////////////////
	
	void setIsActive(bool value);
	bool  getIsActive();
	bool isActive();
	SFBool *getIsActiveField();

	////////////////////////////////////////////////
	//	Translation
	////////////////////////////////////////////////
	
	void setTranslationChanged(float value[]);
	void setTranslationChanged(float x, float y, float z);
	void getTranslationChanged(float value[]);
	SFVec3f *getTranslationChangedField();

	////////////////////////////////////////////////
	//	TrackPoint
	////////////////////////////////////////////////
	
	void setTrackPointChanged(float value[]);
	void setTrackPointChanged(float x, float y, float z);
	void getTrackPointChanged(float value[]);
	SFVec3f *getTrackPointChangedField();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	PlaneSensorNode *next();
	PlaneSensorNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

