/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	SphereNode.h
*
******************************************************************/

#ifndef _SPHERE_H_
#define _SPHERE_H_

#include "GeometryNode.h"

class SphereNode : public GeometryNode {
	
public:

	SphereNode();
	~SphereNode();

	////////////////////////////////////////////////
	//	Radius
	////////////////////////////////////////////////
	
	void setRadius(float value);
	float getRadius();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	SphereNode *next();
	SphereNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void recomputeBoundingBox();

	////////////////////////////////////////////////
	//	recomputeDisplayList
	////////////////////////////////////////////////

#ifdef SUPPORT_OPENGL
	void recomputeDisplayList();
#endif

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

