/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	BackgroundNode.h
*
******************************************************************/

#ifndef _BACKGROUND_H_
#define _BACKGROUND_H_

#include "BindableNode.h"

class BackgroundNode : public BindableNode {
	
public:

	BackgroundNode();
	~BackgroundNode();

	////////////////////////////////////////////////
	// groundColor
	////////////////////////////////////////////////

	void addGroundColor(float value[]);
	int getNGroundColors();
	void getGroundColor(int index, float value[]);

	////////////////////////////////////////////////
	// skyColor
	////////////////////////////////////////////////

	void addSkyColor(float value[]);
	int getNSkyColors();
	void getSkyColor(int index, float value[]);

	////////////////////////////////////////////////
	// groundAngle
	////////////////////////////////////////////////

	void addGroundAngle(float value);
	int getNGroundAngles();
	float getGroundAngle(int index);

	////////////////////////////////////////////////
	// skyAngle
	////////////////////////////////////////////////

	void addSkyAngle(float value);
	int getNSkyAngles();
	float getSkyAngle(int index);

	////////////////////////////////////////////////
	// frontUrl
	////////////////////////////////////////////////

	void addFrontUrl(String value);
	int getNFrontUrls();
	String getFrontUrl(int index);

	////////////////////////////////////////////////
	// backUrl
	////////////////////////////////////////////////

	void addBackUrl(String value);
	int getNBackUrls();
	String getBackUrl(int index);

	////////////////////////////////////////////////
	// leftUrl
	////////////////////////////////////////////////

	void addLeftUrl(String value);
	int getNLeftUrls();
	String getLeftUrl(int index);

	////////////////////////////////////////////////
	// rightUrl
	////////////////////////////////////////////////

	void addRightUrl(String value);
	int getNRightUrls();
	String getRightUrl(int index);

	////////////////////////////////////////////////
	// topUrl
	////////////////////////////////////////////////

	void addTopUrl(String value);
	int getNTopUrls();
	String getTopUrl(int index);

	////////////////////////////////////////////////
	// bottomUrl
	////////////////////////////////////////////////

	void addBottomUrl(String value);
	int getNBottomUrls();
	String getBottomUrl(int index);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	BackgroundNode *next();
	BackgroundNode *nextTraversal();

	////////////////////////////////////////////////
	//	Virtual functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();
	void outputContext(ostream &printStream, String indentString);
};

#endif

