/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	CLinkedListNode.h
*
******************************************************************/

#ifndef _CLINKEDLISTNODE_H_
#define _CLINKEDLISTNODE_H_

#include <stdio.h>

#ifdef SUPPORT_OLDCPP
#include "OldCpp.h"
#endif

template <class T>
class CLinkedListNode {

public:

	bool			mbHeader;
	CLinkedListNode	*mPrevNode;
	CLinkedListNode	*mNextNode;

	CLinkedListNode () {
		setHeaderFlag(0);
		mPrevNode = mNextNode = this;
	}

	CLinkedListNode (bool header) {
		setHeaderFlag(header);
		mPrevNode = mNextNode = this;
	}

	CLinkedListNode (CLinkedListNode *prevNode) {
		setHeaderFlag(0);
		insert(prevNode);
	}

	virtual ~CLinkedListNode(void)
	{
		remove();
	}

	bool isHeaderNode() {
		return mbHeader;
	}

	void setHeaderFlag(bool bHeader) {
		mbHeader = bHeader;
	}

	T *next() {
		if (mNextNode->isHeaderNode())
			return NULL;
		else
			return (T *)mNextNode;
	}

	T* prev() {
		return (T *)mPrevNode;
	}

	T* nextCircular() {
		if (mNextNode->isHeaderNode())
			return (T *)mNextNode->mNextNode;
		else
			return (T *)mNextNode;
	}

	T *prevCircular() {
		if (mPrevNode->isHeaderNode())
			return (T *)mPrevNode->mPrevNode;
		else
			return (T *)mPrevNode;
	}

	void insert(CLinkedListNode *prevNode)
	{
		remove();

		mPrevNode = prevNode;
		mNextNode = prevNode->mNextNode;
		prevNode->mNextNode->mPrevNode = this;
		prevNode->mNextNode = this;
	}

	void remove() {
		mNextNode->mPrevNode = mPrevNode;
		mPrevNode->mNextNode = mNextNode;
		mPrevNode = mNextNode = this;
	}
};

#endif