/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	FogNode.h
*
******************************************************************/

#ifndef _FOG_H_
#define _FOG_H_

#include "BindableNode.h"

class FogNode : public BindableNode {

public:

	FogNode();
	~FogNode();

	////////////////////////////////////////////////
	//	Color
	////////////////////////////////////////////////

	void setColor(float value[]);
	void setColor(float r, float g, float b);
	void getColor(float value[]);

	////////////////////////////////////////////////
	//	FogType
	////////////////////////////////////////////////

	void setFogType(String value);
	String getFogType();

	////////////////////////////////////////////////
	//	VisibilityRange
	////////////////////////////////////////////////

	void setVisibilityRange(float value);
	float getVisibilityRange();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	FogNode *next();
	FogNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

