/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	GeometryNode.h
*
******************************************************************/

#ifndef _GEOMETRYNODE_H_
#define _GEOMETRYNODE_H_

#include "vrmlfields.h"
#include "Node.h"
#include "BoundingBox.h"

#define	bboxCenterPrivateFieldName		"bboxCenter"
#define	bboxSizePrivateFieldName		"bboxSize"

#ifdef SUPPORT_OPENGL
#define	displayListPrivateFieldString	"oglDisplayList"
#endif

class GeometryNode : public Node {

public:

	GeometryNode();
	virtual ~GeometryNode();

	////////////////////////////////////////////////
	//	BoundingBoxSize
	////////////////////////////////////////////////

	void setBoundingBoxSize(float value[]);
	void setBoundingBoxSize(float x, float y, float z);
	void getBoundingBoxSize(float value[]);

	////////////////////////////////////////////////
	//	BoundingBoxCenter
	////////////////////////////////////////////////

	void setBoundingBoxCenter(float value[]);
	void setBoundingBoxCenter(float x, float y, float z);
	void getBoundingBoxCenter(float value[]);

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void setBoundingBox(BoundingBox *bbox);

	////////////////////////////////////////////////
	//	DisplayList
	////////////////////////////////////////////////

#ifdef SUPPORT_OPENGL

	void setDisplayList(unsigned int n);
	unsigned int getDisplayList();
	virtual void draw();

#endif
};

#endif

