/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	GroupingNode.h
*
******************************************************************/

#ifndef _GROUPINGNODE_H_
#define _GROUPINGNODE_H_

#include "Node.h"
#include "BoundingBox.h"

#define	addChildrenEventIn			"addChildren"
#define	removeChildrenEventIn		"removeChildren"
#define	bboxCenterFieldName			"bboxCenter"
#define	bboxSizeFieldName			"bboxSize"

class GroupingNode : public Node {

public:

	GroupingNode();
	virtual ~GroupingNode();

	////////////////////////////////////////////////
	//	BoundingBoxSize
	////////////////////////////////////////////////

	void setBoundingBoxSize(float value[]);
	void setBoundingBoxSize(float x, float y, float z);
	void getBoundingBoxSize(float value[]);

	////////////////////////////////////////////////
	//	BoundingBoxCenter
	////////////////////////////////////////////////

	void setBoundingBoxCenter(float value[]);
	void setBoundingBoxCenter(float x, float y, float z);
	void getBoundingBoxCenter(float value[]);

	////////////////////////////////////////////////
	//	BoundingBox
	////////////////////////////////////////////////

	void setBoundingBox(BoundingBox *bbox);
	void recomputeBoundingBox();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	GroupingNode *next();
	GroupingNode *nextTraversal();
};

#endif

