/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	NavigationInfoNode.h
*
******************************************************************/

#ifndef _NAVIGATIONINFO_H_
#define _NAVIGATIONINFO_H_

#include "BindableNode.h"

class NavigationInfoNode : public BindableNode {
	
public:

	NavigationInfoNode();
	~NavigationInfoNode();

	////////////////////////////////////////////////
	// Type
	////////////////////////////////////////////////

	void addType(String value);
	int getNTypes();
	String getType(int index);

	////////////////////////////////////////////////
	// avatarSize
	////////////////////////////////////////////////

	void addAvatarSize(float value);
	int getNAvatarSizes();
	float getAvatarSize(int index);

	////////////////////////////////////////////////
	//	Headlight
	////////////////////////////////////////////////
	
	void setHeadlight(bool value);
	void setHeadlight(int value);
	bool getHeadlight();

	////////////////////////////////////////////////
	//	VisibilityLimit
	////////////////////////////////////////////////

	void setVisibilityLimit(float value);
	float getVisibilityLimit();

	////////////////////////////////////////////////
	//	Speed
	////////////////////////////////////////////////
	
	void setSpeed(float value);
	float getSpeed();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	bool isChildNodeType(Node *node);
	NavigationInfoNode *next();
	NavigationInfoNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

