/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	Route.h
*
******************************************************************/

#ifndef _ROUTE_H_
#define _ROUTE_H_

#include <iostream.h>
#include "CLinkedList.h"
#include "vrmlfields.h"
#include "vrmlnodes.h"
#include "CJavaVM.h"

#ifdef SUPPORT_JSAI
class Route : public CLinkedListNode<Route>, public CJavaVM {
#else
class Route : public CLinkedListNode<Route> {
#endif

	Node	*mEventOutNode;
	Node	*mEventInNode;
	Field	*mEventOutField;
	Field	*mEventInField;
	
	int		mIsActive;
	void	*mValue;

public:

	Route(Node *eventOutNode, Field *eventOutField, Node *eventInNode, Field *eventInField);
	Route(Route *route);
	~Route(); 

	void	setEventOutNode(Node *node);
	void	setEventInNode(Node *node);
	Node	*getEventOutNode();
	Node	*getEventInNode();
	void	setEventOutField(Field *field);
	Field	*getEventOutField();
	void	setEventInField(Field *field);
	Field	*getEventInField();

	////////////////////////////////////////////////
	//	Active
	////////////////////////////////////////////////

	void setIsActive(int active);
	int	isActive();

	////////////////////////////////////////////////
	//	update
	////////////////////////////////////////////////

	void initialize();
	void update();

	////////////////////////////////////////////////
	//	update
	////////////////////////////////////////////////

	void setValue(void *value); 
	void *getValue();

	////////////////////////////////////////////////
	//	output
	////////////////////////////////////////////////

	void output(ostream& printStream);
};

#endif
