/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	SoundNode.h
*
******************************************************************/

#ifndef _SOUND_H_
#define _SOUND_H_

#include "vrmlfields.h"
#include "Node.h"

class SoundNode : public Node {
	
public:

	SoundNode();
	~SoundNode();

	////////////////////////////////////////////////
	//	Direction
	////////////////////////////////////////////////

	void setDirection(float value[]);
	void setDirection(float x, float y, float z);
	void getDirection(float value[]);

	////////////////////////////////////////////////
	//	Location
	////////////////////////////////////////////////

	void setLocation(float value[]);
	void setLocation(float x, float y, float z);
	void getLocation(float value[]);

	////////////////////////////////////////////////
	//	MinFront
	////////////////////////////////////////////////
	
	void setMinFront(float value);
	float getMinFront();

	////////////////////////////////////////////////
	//	MaxFront
	////////////////////////////////////////////////
	
	void setMaxFront(float value);
	float getMaxFront();

	////////////////////////////////////////////////
	//	MinBack
	////////////////////////////////////////////////
	
	void setMinBack(float value);
	float getMinBack();

	////////////////////////////////////////////////
	//	MaxBack
	////////////////////////////////////////////////
	
	void setMaxBack(float value);
	float getMaxBack();

	////////////////////////////////////////////////
	//	Intensity
	////////////////////////////////////////////////
	
	void setIntensity(float value);
	float getIntensity();

	////////////////////////////////////////////////
	//	Priority
	////////////////////////////////////////////////
	
	void setPriority(float value);
	float getPriority();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	SoundNode *next();
	SoundNode *nextTraversal();

	////////////////////////////////////////////////
	//	Spatialize
	////////////////////////////////////////////////
	
	void setSpatialize(bool value);
	void setSpatialize(int value);
	bool getSpatialize();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

