/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	SphereSensorNode.h
*
******************************************************************/

#ifndef _SPHERESENSOR_H_
#define _SPHERESENSOR_H_

#include "vrmlfields.h"
#include "Node.h"

class SphereSensorNode : public Node {
	
public:

	SphereSensorNode();
	~SphereSensorNode();

	////////////////////////////////////////////////
	//	Enabled
	////////////////////////////////////////////////
	
	void setEnabled(bool value);
	void setEnabled(int value);
	bool getEnabled();
	bool  isEnabled();

	////////////////////////////////////////////////
	//	AutoOffset
	////////////////////////////////////////////////
	
	void setAutoOffset(bool value);
	void setAutoOffset(int value);
	bool getAutoOffset();
	bool  isAutoOffset();

	////////////////////////////////////////////////
	//	Offset
	////////////////////////////////////////////////
	
	void setOffset(float value[]);
	void getOffset(float value[]);

	////////////////////////////////////////////////
	//	isActive
	////////////////////////////////////////////////
	
	void setIsActive(bool  value);
	void setIsActive(int value);
	bool  getIsActive();
	bool  isActive();

	////////////////////////////////////////////////
	//	Rotation
	////////////////////////////////////////////////
	
	void setRotationChanged(float value[]);
	void setRotationChanged(float x, float y, float z, float rot);
	void getRotationChanged(float value[]);

	////////////////////////////////////////////////
	//	TrackPoint
	////////////////////////////////////////////////
	
	void setTrackPointChanged(float value[]);
	void setTrackPointChanged(float x, float y, float z);
	void getTrackPointChanged(float value[]);

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	SphereSensorNode *next();
	SphereSensorNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

