/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	SwitchNode.h
*
******************************************************************/

#ifndef _SWITCH_H_
#define _SWITCH_H_

#include "vrmlfields.h"
#include "Node.h"
#include "JVector.h"

class SwitchNode : public Node {

public:

	SwitchNode();
	~SwitchNode();

	////////////////////////////////////////////////
	//	whichChoice
	////////////////////////////////////////////////

	void setWhichChoice(int value);
	int getWhichChoice();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	SwitchNode *next();
	SwitchNode *nextTraversal();

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream &printStream, String indentString);
};

#endif

