/******************************************************************
*
*	VRML library for C++
*
*	Copyright (C) Satoshi Konno 1996-1997
*
*	File:	WorldInfoNode.h
*
******************************************************************/

#ifndef _WORLDINFO_H_
#define _WORLDINFO_H_

#include "vrmlfields.h"
#include "Node.h"

class WorldInfoNode : public Node {

public:

	WorldInfoNode();
	~WorldInfoNode();

	////////////////////////////////////////////////
	//	List
	////////////////////////////////////////////////

	WorldInfoNode *next();
	WorldInfoNode *nextTraversal();

	////////////////////////////////////////////////
	//	Title
	////////////////////////////////////////////////
	
	void setTitle(String value);
	String getTitle();

	////////////////////////////////////////////////
	// Info
	////////////////////////////////////////////////

	void addInfo(String value);
	int getNInfos();
	String getInfo(int index);

	////////////////////////////////////////////////
	//	functions
	////////////////////////////////////////////////
	
	bool isChildNodeType(Node *node);
	void initialize();
	void uninitialize();
	void update();

	////////////////////////////////////////////////
	//	Infomation
	////////////////////////////////////////////////

	void outputContext(ostream& printStream, String indentString);
};

#endif
