/* 
 *Database Connect Driver Wrapper
 *
 * Author  : Johnathan Ingram
 * Date    : 31 August 1999
 * Updated :
 *   Version 0.2.0 : 16 July 2001, Johnathan Ingram
 * 
 * Requires defines by configure script
 *   #define driver_MYSQL
 *   #define driver_PGSQL
 *   #define driver_ODBC
 *   #define driver_ORACLE8
 *   #define driver_MSQL
 *
 * NOTE: All functions are zero index based.
 */




#ifndef _dbconn
#define _dbconn

#include <stdio.h>
#include <vector>
#include <dbconnect_basedriver.h>

#ifdef driver_MYSQL
	#include <dbconnect_MYSQL.h>
#endif

#ifdef driver_PGSQL
	#include <dbconnect_PGSQL.h>
#endif

#ifdef driver_ODBC
	#include <dbconnect_ODBC.h>
#endif

#ifdef driver_ORACLE8
	#include <dbconnect_ORACLE8.h>
#endif

#ifdef driver_MSQL
	#include <dbconnect_MSQL.h>
#endif


struct fieldInfo 
{
	char                fieldName[256];
	long int            fieldNum;
	DBFieldType         fieldType; 
	DBFieldTypeCategory fieldTypeCat;
	bool                autoIncrement;
	bool                primaryKey;
	bool                unique;
	bool                notNull;
	long int            precision;
	long int            scale;
};


class dbconn
{
	private:
		//Reference to the Driver Object
		BASE_Driver *driverREF;

		//Private Methods
		void SetProperties();

	public:
		enum driverType
		{
			NONE,
			ORACLE8,
			MYSQL,
			PGSQL,
			MSQL,
			ODBC
		};

		driverType __driver;
    
		//Properties   
		bool     connected;               //Determine if there is an active connection.
		bool     bof;                     //Determine if at the begining of the record set.
		bool     eof;                     //Determine if at the end of the record set.
		bool     transaction;             //Determine if a transaction is active.
		long int recordNum;               //Current record num that is been accessed.
		long int recordCount;    //Number of records returned by the query.
		long int affectedRows;   //Number of records affected by the query. (Like update, insert ect)
		long int lastIdentity;   //Last identity inserted into an auto-increment column.
		long int fieldCount;     //Numbert of fields in the record set.

		//Constructor and Destructor.
		dbconn(driverType driver);
		~dbconn();

		//Methods
		int   errorCode();
		char* errorMsg();

		bool connect(char *host, char *db_name, char *user, char *password);
		bool disconnect();

		void clearBindParams();
		BASE_DBBindParameter* bindParam(char *bname);
		BASE_DBBindParameter* bindParam(int bpos);
		bool execute(char* query);

		bool first();
		bool last();
		bool next();
		bool prev();

		bool transBegin();
		bool transCommit();
		bool transRollback();

		char*         getFieldName(unsigned int fieldNum);
		long int      getFieldColumn(char* fieldName);

		BASE_DBField* getFieldByName(char* fieldName);
		BASE_DBField* getFieldByColumn(unsigned long int fieldNum);
		bool          setFieldArrayIndexByColumn(unsigned long int fieldNum, char *index);

		bool          isNULLFieldByName(char* fieldName);
		bool          isNULLFieldByColumn(unsigned long int fieldNum);

		fieldInfo     getFieldInfoByName(char* fieldName);
		fieldInfo     getFieldInfoByColumn(unsigned long int fieldNum);
		
		//Information functions.
		char*         getFieldTypeString(DBFieldType type, DBFieldTypeCategory cat);
		int           getFieldArrayNumDimensions(unsigned long int fieldNum);
		int	       getFieldArrayDimensionSize(unsigned long int fieldNum, int dimensionNum);
};

#endif
