/***************************************************************************

    Disk Based Hash library DBH


    Header file.


copyright Edscott Wilson Garcia 2002
published under QPL Public license
You should have received a license copy along with this file.

*************************************************************************/

/* This tmpdir should be set to /tmp, but DBH_sort will fail since
 * it involves a "rename" which would does not work across file
 * systems. */
#define DBH_TMP_DIR "."

#define READ                    0
#define WRITE                   1
#define DOWN                    0
#define UP                      1

#define WRITEBRANCHES           1
#define DONTWRITEBRANCHES       0

#define PRESENTE  				  0
#define PRESENTE_MENOR_BOF      0
#define PRESENTE_MENOR          1
#define PRESENTE_MAYORIGUAL     2
#define ARCHIVO_VACIO           3
#define NO_PRESENTE             4
#define ERROR_VALUE             0

#ifdef BCC32
#include <dbh_config_bcc32.h>
#else
#include <dbh_config.h>
#endif
#ifndef DBH_VERSION
#error "DBH_VERSION NOT DEFINED"
#endif

#ifdef I16_32
#define FILE_POINTER long int
#endif

#ifdef I32_32
#define FILE_POINTER int
#endif

#ifdef I64_32
#define FILE_POINTER short int
#warning "I64_32 mode disabled"
#endif

#ifdef I64_64
#warning "I64_64 mode disabled"
#endif

#ifdef I32_64
#warning "I32_64 mode disabled"
#endif


/* default */
#ifndef FILE_POINTER
#define FILE_POINTER int
#endif


/* tipos (privados): */
#define HEADER_SIZE 1024
typedef struct header
{
	/****    32 bytes  *****/
 unsigned char   n_limit;         /*  1.  1  Maximum toplevel branches */
 unsigned char   position;        /*  2.  1  position of key in data 
				          (for tables) */
 unsigned char   length;          /*  3.  1  length of key in data 
				          (for tables) */
 unsigned char   totalkeylength;  /*  4.  1  total length of key in data 
				          (for tables) */
 unsigned char   descending;      /*  5.  1  inverse order for function sort */
 unsigned char   DBH32;           /*  6.  1  if TRUE, sizeof(FILE_POINTER)=4, 
				          else 8 */
 unsigned char   reservedC;       /*  7.  1  (used by system, value goes to 0 
				          on updates or inserts)*/
 unsigned char   reservedD;       /*  8.  1  same as above, used in insert()*/
 unsigned char   sweep_erased;    /*  9.  0 */
 unsigned char	 writeOK;         /*  10. reserved for inner use */
 unsigned char	 DBH_exit;        /*  11. reserved for inner use */
 unsigned char   avail_uc[32-11]; /*  12 thru 32. */
 
	/****     80*4 = 320 bytes  *****/
 FILE_POINTER    bof;             /*  1.  root of tree. */
 FILE_POINTER    erased_space;    /*  2.  */
 FILE_POINTER    data_space;      /*  3.  */
 FILE_POINTER    total_space;     /*  4.  erased_space+data_space
				          +format_space */
 FILE_POINTER    records;         /*  5.  number of records */
 FILE_POINTER    record_length;   /*  6.  Maximum record length  */
 FILE_POINTER    reservedA;       /*  7.  Reserved for erase */
 FILE_POINTER    reservedB;       /*  8.  Reserved, contains last 
				          FILE_POINTER read by load_address */
 
 FILE_POINTER     deltaX;          /* 9.  valor frontera para cuadricula 
				          fractal  */
 FILE_POINTER     deltaY;          /* 10. valor frontera para cuadricula 
				          fractal  */
 FILE_POINTER     minX;            /* 11. valor frontera para cuadricula 
				          fractal  */
 FILE_POINTER     minY;            /* 12. valor frontera para cuadricula 
				          fractal  */
 FILE_POINTER     base;            /* 13. base de division en llave fractal 
				          <= 16 */
 FILE_POINTER     fractalidad;     /* 14. grado de fractalidad o anidamiento */
 FILE_POINTER     avail32[80-14];  /* 15 thru 80 (max 40 for 64 bit support) */
	/****     bytes  16+256 *****/ 
 char             version[16];     /*  16  informacion del encabezado  (fijo) */
 char             archivo[256];    /*  256 para referencias posteriores, 
				           nombre del archivo */
	/****     bytes  16+256 *****/ 
 unsigned char    *membof;         /*  keep this one last! */
  
 unsigned char   padding[HEADER_SIZE-320-32-16-256-SIZEOF_UNSIGNED_CHAR_P];    /*   */
} header;

typedef struct DBHashTable
{
 unsigned char   branches;           /* se guarda en registro              */
 unsigned char   newbranches;        /* para operaciones de busqueda   */
 unsigned char   flag;               /* reservado              */
 unsigned char   reservedB;          /* reservado              */
 unsigned char   reservedBB;         /* reservado   */
 FILE_POINTER    bytes_userdata;     /* se guarda en registro              */
 FILE_POINTER    newbytes_userdata;  /* para operaciones de busqueda   */
 FILE_POINTER    *branch;            /* se guarda en registro (arreglo)    */
 FILE_POINTER    *newbranch;         /* para operaciones de busqueda (arreglo)*/
 unsigned char   *key;               /* la llave de acceso */
 unsigned char   *newkey;
 unsigned char   *reservedC;         /* reservado */
 unsigned char   *reservedD;         /* reservado */
 void            *data;              /* se guarda en registro lo apuntado */
 void            *newdata;           /* para operaciones de busqueda (arreglo)*/
 void            (*operate)(struct DBHashTable *);  /* para funcion barre    */
 void            (*reservedE)(void *);        /* reservado    */
 void            *((*reservedF)(void *));     /* reservado    */
 void            *((*reservedG)(void *));     /* reservado    */
 FILE            *database;          /* para operaciones de archivo      */
 header          *head_info;         /* informacion del encabezado 
					(en DBHashTable file) */
} DBHashTable;

typedef void (*DBHashFunc)(struct DBHashTable *);

#include <dbh_functions.h>

#define DBH_KEYLENGTH(x) (x->head_info->n_limit)
#define DBH_RECORD_SIZE(x) (x->bytes_userdata)
#define DBH_KEY(x) (x->key)
#define DBH_DATA(x) (x->data)
#define DBH_ERASED_SPACE(x) (x->head_info->erased_space)
#define DBH_DATA_SPACE(x) (x->head_info->data_space)
#define DBH_TOTAL_SPACE(x) (x->head_info->total_space)
#define DBH_FORMAT_SPACE(x) (x->head_info->total_space - x->head_info->data_space - x->head_info->erased_space)
#define DBH_RECORDS(x) (x->head_info->records)
#define DBH_MAXIMUM_RECORD_SIZE(x) (x->head_info->record_length)
#define DBH_PATH(x) (x->head_info->archivo)

