/***************************************************************************

    Disk Based Hash library DBH


    Header function file.


copyright Edscott Wilson Garcia 2002
published under QPL Public license
You should have received a license copy along with this file.

*************************************************************************/
/* level 1 functions ***********************************/


/* Open an existing hash in read-write mode */
DBHashTable *             
DBH_open(char *);

/* open an existing hash in read-only mode */
DBHashTable *             
DBH_openR(char *);

/* create a new hash file (overwriting old version) */
DBHashTable *             
DBH_create(char *,
		unsigned char);

/* close hash file (thus flushing io buffer) */
int                 
DBH_close(DBHashTable *);

/* Load a record from hash table directly from file pointer */
unsigned char       
DBH_load_address(DBHashTable *,
		FILE_POINTER);

/* Load a record using hash key */
FILE_POINTER        
DBH_load(DBHashTable *);

/* Load the parent of the current loaded record */
FILE_POINTER        
DBH_load_parent(DBHashTable *);

/* Load the first child (on the selected key index branch) of the current loaded record */
FILE_POINTER        
DBH_load_child(DBHashTable *,unsigned char);

//* return the file pointer to a record with the set hash key */
FILE_POINTER        
DBH_find(DBHashTable *,
		int);

/* update the current record to the hash*/
FILE_POINTER        
DBH_update(DBHashTable *);

/* erase a whole subtree */
int DBH_prune(DBHashTable *,unsigned char *,unsigned char );
/* unerase a whole subtree */
int DBH_unprune(DBHashTable *,unsigned char *,unsigned char );
/* mark the current hash record as erased */
int        
DBH_erase(DBHashTable *);

/* unmark the current hash record as erased */
int        
DBH_unerase(DBHashTable *);

int 
DBH_foreach_sweep(DBHashTable *,DBHashFunc);

int 
DBH_foreach_fanout(DBHashTable *,DBHashFunc);

int                 
DBH_sweep(DBHashTable *,DBHashFunc,
		unsigned char *,
		unsigned char *,
		unsigned char);
int                 
DBH_fanout(DBHashTable *,DBHashFunc,
		unsigned char *,
		unsigned char *,
		unsigned char);
void 
DBH_orderkey(unsigned char *numero,
	       unsigned char orden,
	       unsigned int n, 
	       unsigned char base);
void                
DBH_genkey(unsigned char *,
		unsigned char,
		unsigned int);
void                
DBH_genkey2(unsigned char *,
		unsigned char,
		unsigned int);
DBHashTable *             
DBH_regen(DBHashTable *);

int 
DBH_writeheader(DBHashTable *);

int             
DBH_Size(DBHashTable *,
		int);
void 
DBH_exitsweep(DBHashTable *);
void 
DBH_set_recordsize(DBHashTable *,
		int);
void 
DBH_set_key(DBHashTable *,
		char *);
void 
DBH_set_data(DBHashTable *,
		void *,
		int);




DBHashTable * 
DBH_destroy(DBHashTable *node);




/* level 2 functions ***********************************/
/* FIXME: language for info, and specific functions for each of the elements */
int               
DBH_info(DBHashTable *);

void                
DBH_genkey0(unsigned char *,
		unsigned char,
		unsigned int);

char *              
DBH_randomfilename(char);


DBHashTable *             
DBH_regenMEM(DBHashTable *);

/* FIXME: insert function not fully verified */
FILE_POINTER        
DBH_insert(DBHashTable *);

/* FIXME: does this depend on DBH_insert? If so, is DBH_insert completely verified? */
DBHashTable *             
DBH_sort(DBHashTable *,
		int );

void 
DBH_settempdir(char *);

DBHashTable * 
DBH_openmem(char *);

int 
DBH_closemem(DBHashTable *);

FILE_POINTER 
DBH_loadmem(DBHashTable *);

int 
DBH_membarre(DBHashTable *,
		unsigned char *,
		unsigned char *,
		unsigned char);

int 
DBH_Eunzip(DBHashTable *,
		unsigned int,
		unsigned int );

int 
DBH_Ezip(DBHashTable *,
		unsigned int,
		unsigned int );


/* medium security encryption for data field of DBH records.
 * use at your own risk! */
int 
DBH_crypt(DBHashTable *);

int 
DBH_decrypt(DBHashTable *);


