/***************************************************************************
                           cfilemanager.h  -  description
                             -------------------
    begin                : Sat Aug 03 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFILEMANAGER_H
#define CFILEMANAGER_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/cobject.h>
#include <dclib/clist.h>
#include <dclib/cstringlist.h>
#include <dclib/cthread.h>
#include <dclib/cmessagehandler.h>

class CStringList;
class CThreadStringList;
class CFileInfo;

class DLL_EXPORT CFileBaseObject : public CObject {
public:
	/** */
	CFileBaseObject() {
		ID         = 0;
		lSize      = 0;
		eFileType  = eftUNKNOWN;
		sPath      = "";
		sFile      = "";
		sMD5Hash   = "";
		sMD4Hash   = "";
		st_a_time  = 0;
		st_m_time  = 0;
		st_c_time  = 0;
	};
	/** */
	CFileBaseObject( CFileBaseObject * FileBaseObject ) {
		ID         = FileBaseObject->ID;
		lSize      = FileBaseObject->lSize;
		eFileType  = FileBaseObject->eFileType;
		sPath      = FileBaseObject->sPath;
		sFile      = FileBaseObject->sFile;
		sMD5Hash   = FileBaseObject->sMD5Hash;
		sMD4Hash   = FileBaseObject->sMD4Hash;
		st_a_time  = FileBaseObject->st_a_time;
		st_m_time  = FileBaseObject->st_m_time;
		st_c_time  = FileBaseObject->st_c_time;

		CString *s = 0;

		while( (s = FileBaseObject->pMD4ChunkHashList.Next(s)) != 0 )
		{
			pMD4ChunkHashList.Add( new CString(*s) );
		}
	};
	/** */
	virtual ~CFileBaseObject() {};

	/** */
	ulonglong ID;
	/** */
	eFileTypes eFileType;
	/** */
	ulonglong lSize;
	/** */
	CString sRootPath;
	/** */
	CString sPath;
	/** */
	CString sFile;
	/** */
	CString sMD4Hash;
	/** */
	CList<CString> pMD4ChunkHashList;
	/** */
	CString sMD5Hash;
	/** */
	time_t st_a_time;
	/** */
	time_t st_m_time;
	/** */
	time_t st_c_time;
};

class DLL_EXPORT CFileManager : public CThread {

public:
	/** */
	CFileManager();
	/** */
	virtual ~CFileManager();

	/** */
	void SaveIndex();
	/** */
	void StartIndex();
	/** */
	void StopIndex();
	/** */
	void AddIndex( CFileInfo *fileinfo, CString path, CString rootpath );
	/** */
	CStringList * Search( CString s );
	/** */
	CFileBaseObject * GetFileBaseObject( CString id );

	/** thread callbackfunction */
	virtual void Thread( CObject * Object );

private:
	/** */
	void CreateSearchIndex();

	/** */
	CThreadStringList * pFileBaseList;
	/** */
	CThreadStringList * pFileList;
	/** */
	CThreadStringList * pTempFileList;
	/** */
	CThreadStringList * pTempFileBaseList;
	/** string index */
	CStringList * pQueryStringIndex;

	/** return the filetype */
	eFileTypes GetFileType( CString file );

	/** */
	bool bCreateIndex;
};

extern CFileManager * pFileManager;

#endif
