/***************************************************************************
                         ccallback.h  -  description
                             -------------------
    begin                : Thu Aug 1 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CCALLBACK_H
#define CCALLBACK_H

#include <dclib/dcos.h>
#include <dclib/cobject.h>

/**
  *@author Mathias Kster
  */

class  DLL_EXPORT _CCallback : public CObject
{
public:
	/** */
	_CCallback() {};
	/** */
	virtual ~_CCallback() {};

	/** */
	virtual int notify( CObject * Sender, CObject * Object ) = 0;
};

template<class T> class DLL_EXPORT CCallback : public _CCallback {
public:
	/** */
	CCallback(T* object, int (T::*method)( CObject * Sender, CObject * Object ))
		: myObject(object),
		  myMethod(method)
	{}
	/** */
	virtual ~CCallback() {};

	/** */
	virtual int notify( CObject * Sender, CObject * Object )
	{
		return (myObject->*myMethod)( Sender, Object );
	}

	/** */
	T*        myObject;
	/** */
	int (T::*myMethod)( CObject * Sender, CObject * Object );
};

#endif
