/***************************************************************************
                          chubsearch.h  -  description
                             -------------------
    begin                : Fri Mar 15 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHUBSEARCH_H
#define CHUBSEARCH_H

#include <time.h>

#include <dclib/dcos.h>
#include <dclib/cstring.h>
#include <dclib/cclient.h>
#include <dclib/cstringlist.h>
#include <dclib/cconnection.h>
#include <dclib/cbytearray.h>

/**
  *@author Mathias Kster
  */

typedef enum eHubSearchType {
	ehstNONE,
	ehstLOCAL,
	ehstGLOBAL,
	ehstWAITTIMEOUT,
	ehstSTOP
} eHubSearchType;

class DLL_EXPORT sHubSearchClient : public CObject {
public:
	/** */
	CClient * Client;
	/** */
	bool bRemove;
	/** */
	time_t timeHubTimeout;
};

class DLL_EXPORT CHubSearch : public CConnection {
public:
	CHubSearch();
	~CHubSearch();

	/** callback function */
	virtual int DC_CallBack( CObject * ) { return -1; };
	/** */
	virtual void DataAvailable( const char * buffer, int len );
	/** */
	virtual void ConnectionState( eConnectionState state );

	/** */
	int StartSearch( int mode );
	/** */
	void StopSearch();

	/** */
	int HandleMessage( char * c, int len );
	/** */
	int DC_ClientCallBack( CObject * Client, CObject * Object );
	/** */
	int DC_ManagerCallBack( CObject *, CObject * );

protected:
	/** */
	eHubSearchType ehSearchType;
	/** store clients */
	CList<CObject> * pHubSearchClientList;
	/** */
	CStringList *pHubServerList;
	/** */
	int iMaxThreads;
	/** */
	time_t tStartTime;
	/** */
	CString sSearchString;
	/** */
	long iCurrentHubServer;

private:
	/** */
	CString sBuffer;

	/** */
	CThread ManagerThread;
	/** */
	CThread ClientThread;
	/** */
	CThread HubSearchClientListThread;

	CString * sCurrentServer;
	/** */
	void SendDebug( CString s );
	/** */
	void SendSearchResult( CObject * object );
	/** */
	void CheckClient();
	/** mark client as removeable */
	void RemoveClient( CClient * Client );
	/** create new client connection */
	void NewClient();
};

#endif
