/***************************************************************************
                          csocket.h  -  description
                             -------------------
    begin                : Sat Oct 6 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSOCKET_H
#define CSOCKET_H

#include <dclib/dcos.h>
#include <dclib/cobject.h>
#include <dclib/cstring.h>

/**
  *@author Mathias Kster
  */

typedef enum eSocketType {
	estTCP,
	estUDP
} eSocketType;

typedef enum eConnectState {
	ecsSUCCESS=0,
	ecsAGAIN,
	ecsERROR
} eConnectState;

class DLL_EXPORT CSocket : public CObject {
public: 
	/** */
	CSocket();
	/** */
	virtual ~CSocket();

	/** */
	eConnectState Connect( CString Host, int Port, int iAsync = 1 );
	/** */
	int IsConnect();
	/** */
	int Disconnect();
	/** */
	int Read( char * buffer, int len, int sec_timeout=0, int usec_timeout=0 );
	/** */
	int Write( const char * buffer, int len, int sec_timeout=0, int usec_timeout=0 );
	/** */
	static CString GetHostByName( CString Host );
	/** */
	CString GetInterfaceIP( CString iface );
	/** */
	int GetFreeSendBufferSize();

	/** */
	int Accept();
	/** */
	int Listen( int port );
	/** */
	int GetPeerName( CString * host, int * port );

	/** */
	CString GetSocketError() { return sError; };

protected:
	/** */
	eSocketType SocketType;
	/** */
	SOCKET iHandle;

private:
	/** */
	CString sError;
};

#endif
