/***************************************************************************
                          cthread.h  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CTHREAD_H
#define CTHREAD_H

/**
  *@author Mathias Kster
  */

#include <pthread.h>

#include <dclib/dcos.h>
#include <dclib/cobject.h>
#include <dclib/ccallback.h>

class DLL_EXPORT CThread {
public:
	/** */
	CThread();
	/** */
	virtual ~CThread();

	/** */
	int Start();
	/** */
	int Stop( bool bHard = TRUE );
	/** */
	int Lock();
	/** */
	bool TryLock();
	/** */
	int UnLock();
	/** */
	bool Stopped() const;

	/** */
	void SetThreadCallBackFunction( _CCallback * callback );

	/** */
	virtual void Thread(CObject *) {};


protected:
	/** */
	int iRun;

private:
	/** callback function */
	_CCallback * _thread_callback_function;
	/** */
	pthread_t thread;
	/** */
	pthread_mutex_t mutex;
	/** */
	int iStop;
	/** */
	static void * MainThread(void *object);
};

/** */
inline int CThread::Lock()
{ return pthread_mutex_lock(&mutex);}
/** */
inline bool CThread::TryLock()
{ return ( pthread_mutex_trylock(&mutex) == 0 ); }
/** */
inline int CThread::UnLock()
{ return pthread_mutex_unlock(&mutex);}
/** */
inline void CThread::SetThreadCallBackFunction( _CCallback * callback )
{ Lock(); if ( _thread_callback_function ) delete _thread_callback_function; _thread_callback_function = callback; UnLock(); }
/** */
inline bool CThread::Stopped() const
{ return iStop; }

#endif
