/* DiaCanvas -- A technical drawing canvas.
 * Copyright (C) 1999, Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/* Original license:
 * Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* diagrid.h
 * ---------
 * Functions for the grid drawing stuff. This file is basically a part of
 * diadisplay.h, but is separated since the amounts of code are already
 * enough.
 */

#ifndef __DIA_GRID_H__
#define __DIA_GRID_H__

#include <gtk/gtk.h>
#include <diacanvas/geometry.h>
#include <diacanvas/diacolor.h>
#include <diacanvas/diadefs.h>

DIA_OPEN

#define GRID_MIN_SIZE 0.1
#define GRID_MAX_SIZE 500.0

#define GRID_MIN_INTERVAL 1
#define GRID_MAX_INTERVAL 64 /* 2^6 --> don't change if point_x/y_interval
			      * remains unchanged!!! */

typedef struct _DiaGrid DiaGrid;

struct _DiaGrid
{
  gfloat width_x;
  gfloat width_y;
  
  guint point_grid : 1; /* draw the grid as lines or as points */
  guint interval_x : 6; 
  guint interval_y : 6; 

  guint visible: 1;
  guint snap: 1;

  DiaColor color;
    
  //GdkGC *gc;

  /* GtkWidget *dialog; */         /* The dialog for changing the grid  */
  gpointer data;
};

/* include DIA_DISPLAY here cause it uses by some functions */
#include <diacanvas/diadisplay.h>


void dia_grid_init (DiaGrid *grid);

void dia_grid_draw (DiaDisplay *disp, Rectangle *update_box);

/* convert coordinates to snap coordinates if nessesary.
 */
gboolean dia_grid_snap (DiaGrid *grid, gfloat *x, gfloat *y);

DIA_CLOSE

#endif /* __DIA_GRID_H__ */

