# Configure paths for DIACANVAS
# Owen Taylor     97-11-3
# Addapted for DiaCanvas by Arjan Molenaar 99-5-14

dnl AM_PATH_DIACANVAS([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for DIACANVAS, and define DIACANVAS_CFLAGS and DIACANVAS_LIBS
dnl
AC_DEFUN(AM_PATH_DIACANVAS,
[dnl 
dnl Get the cflags and libraries from the diacanvas-config script
dnl
AC_ARG_WITH(diacanvas-prefix,[  --with-diacanvas-prefix=PFX   Prefix where DIACANVAS is installed (optional)],
            diacanvas_config_prefix="$withval", diacanvas_config_prefix="")
AC_ARG_WITH(diacanvas-exec-prefix,[  --with-diacanvas-exec-prefix=PFX Exec prefix where DIACANVAS is installed (optional)],
            diacanvas_config_exec_prefix="$withval", diacanvas_config_exec_prefix="")
AC_ARG_ENABLE(diacanvastest, [  --disable-diacanvastest       Do not try to compile and run a test DIACANVAS program],
		    , enable_diacanvastest=yes)

  for module in . $4
  do
      case "$module" in
         gthread) 
             diacanvas_config_args="$diacanvas_config_args gthread"
         ;;
      esac
  done

  if test x$diacanvas_config_exec_prefix != x ; then
     diacanvas_config_args="$diacanvas_config_args --exec-prefix=$diacanvas_config_exec_prefix"
     if test x${DIACANVAS_CONFIG+set} != xset ; then
        DIACANVAS_CONFIG=$diacanvas_config_exec_prefix/bin/diacanvas-config
     fi
  fi
  if test x$diacanvas_config_prefix != x ; then
     diacanvas_config_args="$diacanvas_config_args --prefix=$diacanvas_config_prefix"
     if test x${DIACANVAS_CONFIG+set} != xset ; then
        DIACANVAS_CONFIG=$diacanvas_config_prefix/bin/diacanvas-config
     fi
  fi

  AC_PATH_PROG(DIACANVAS_CONFIG, diacanvas-config, no)
  min_diacanvas_version=ifelse([$1], ,0.10.0,$1)
  AC_MSG_CHECKING(for DiaCanvas - version >= $min_diacanvas_version)
  no_diacanvas=""
  if test "$DIACANVAS_CONFIG" = "no" ; then
    no_diacanvas=yes
  else
    DIACANVAS_CFLAGS=`$DIACANVAS_CONFIG $diacanvas_config_args --cflags`
    DIACANVAS_LIBS=`$DIACANVAS_CONFIG $diacanvas_config_args --libs`
dnl
dnl extracting version numbers from string
dnl
    diacanvas_config_major_version=`$DIACANVAS_CONFIG $diacanvas_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    diacanvas_config_minor_version=`$DIACANVAS_CONFIG $diacanvas_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    diacanvas_config_micro_version=`$DIACANVAS_CONFIG $diacanvas_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_diacanvastest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $DIACANVAS_CFLAGS"
      LIBS="$DIACANVAS_LIBS $LIBS"
dnl
dnl Now check if the installed DiaCanvas is sufficiently new. (Also sanity
dnl checks the results of diacanvas-config to some extent
dnl
      rm -f conf.diacanvastest
      AC_TRY_RUN([
#include <diacanvas/diamain.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro; 
  int diacanvas_major_version, diacanvas_minor_version, diacanvas_micro_version;
  char *tmp_version;

  system ("touch conf.diacanvastest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_diacanvas_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_diacanvas_version");
     exit(1);
   }
  if (sscanf(dia_canvas_current_version, "%d.%d.%d", &diacanvas_major_version,
             &diacanvas_minor_version, &diacanvas_micro_version) != 3) {
     printf("%s, bad version string from the DiaCanvas widget\n", "$min_diacanvas_version");
     exit(1);
   }

  if ((diacanvas_major_version != $diacanvas_config_major_version) ||
      (diacanvas_minor_version != $diacanvas_config_minor_version) ||
      (diacanvas_micro_version != $diacanvas_config_micro_version))
    {
      printf ("\n*** 'diacanvas-config --version' returned %d.%d.%d, but DiaCanvas (%d.%d.%d)\n", 
              $diacanvas_config_major_version, $diacanvas_config_minor_version, $diacanvas_config_micro_version,
              diacanvas_major_version, diacanvas_minor_version, diacanvas_micro_version);
      printf ("*** was found! If diacanvas-config was correct, then it is best\n");
      printf ("*** to remove the old version of DiaCanvas. You may also be able to fix the\n");
      printf ("*** error by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf ("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf ("*** required on your system.\n");
      printf ("*** If diacanvas-config was wrong, set the environment variable DIACANVAS_CONFIG\n");
      printf ("*** to point to the correct copy of diacanvas-config, and remove the file\n");
      printf ("*** config.cache before re-running configure.\n");
    } 
#if defined (DIA_CANVAS_MAJOR_VERSION) && defined (DIA_CANVAS_MINOR_VERSION) && defined (DIA_CANVAS_MICRO_VERSION)
  else if ((diacanvas_major_version != DIA_CANVAS_MAJOR_VERSION) ||
	   (diacanvas_minor_version != DIA_CANVAS_MINOR_VERSION) ||
           (diacanvas_micro_version != DIA_CANVAS_MICRO_VERSION))
    {
      printf("*** DIACANVAS header files (version %d.%d.%d) do not match\n",
	     DIA_CANVAS_MAJOR_VERSION, DIA_CANVAS_MINOR_VERSION, DIA_CANVAS_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     diacanvas_major_version, diacanvas_minor_version, diacanvas_micro_version);
    }
#endif /* defined (DIA_CANVAS_MAJOR_VERSION) ... */
  else
    {
      if ((diacanvas_major_version > major) ||
        ((diacanvas_major_version == major) && (diacanvas_minor_version > minor)) ||
        ((diacanvas_major_version == major) && (diacanvas_minor_version == minor) && (diacanvas_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of DiaCanvas (%d.%d.%d) was found.\n",
               diacanvas_major_version, diacanvas_minor_version, diacanvas_micro_version);
        printf("*** You need a version of DiaCanvas newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** DiaCanvas is always available from http://web.inter.nl.net/hcc/klem.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the diacanvas-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of DiaCanvas, but you can also set the DIACANVAS_CONFIG environment to\n");
        printf("*** point to the correct copy of diacanvas-config. (In this case, you will have\n");
        printf("*** to modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time)).\n");
      }
    }
  return 1;
}
],, no_diacanvas=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_diacanvas" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$DIACANVAS_CONFIG" = "no" ; then
       echo "*** The diacanvas-config script installed by DiaCanvas could not be found"
       echo "*** If DiaCanvas was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the DIACANVAS_CONFIG environment variable to the"
       echo "*** full path to diacanvas-config."
     else
       if test -f conf.diacanvastest ; then
        :
       else
          echo "*** Could not run DiaCanvas test program, checking why..."
          CFLAGS="$CFLAGS $DIACANVAS_CFLAGS"
          LIBS="$LIBS $DIACANVAS_LIBS"
          AC_TRY_LINK([
#include <diacanvas/diamain.h>
#include <stdio.h>
],      [ return ((diacanvas_major_version) || (diacanvas_minor_version) || (diacanvas_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding DiaCanvas or finding the wrong"
          echo "*** version of DiaCanvas. If it is not finding DiaCanvas, you'll need to set"
          echo "*** your LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to"
          echo "*** point to the installed location  Also, make sure you have run ldconfig"
          echo "*** if that is required on your system."
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH."
          echo "***"
          echo "*** If you have a RedHat 5.0 system, you should remove the DiaCanvas package"
          echo "*** that came with the system with the command."
          echo "***"
          echo "***    rpm --erase --nodeps diacanvas diacanvas-devel" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for"
          echo "*** the exact error that occured. This usually means DiaCanvas was incorrectly"
          echo "*** installed or that you have moved DiaCanvas since it was installed. In the"
          echo "*** latter case, you may want to edit the diacanvas-config script:\n");
	  echo "*** $DIACANVAS_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     DIACANVAS_CFLAGS=""
     DIACANVAS_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(DIACANVAS_CFLAGS)
  AC_SUBST(DIACANVAS_LIBS)
  rm -f conf.diacanvastest
])

