Chapter 3
=========

  The Runtime Control Language 


3.1 Introduction 
================

  Perhaps in reading  the chapter on  the PDL (Chapter  2) you missed 
  any  mention of  how to  turn preconditions,  postconditions, debug 
  instructions, etc. on and off. 


  The reason that the corresponding  control mechanism is not part of 
  the  PDL is  that  in our  opinion the  sole  task of  the Eiffel/S 
  compiler should be to make executable programs out of Eiffel source 
  code. Since preconditions for example are part of the Eiffel source 
  code,  the compiler  must generate  executable  code for  them. The 
  question  of  whether  this code  is  actually  executed  should be 
  controlled by an independent mechanism. 


  One can readily  imagine that different  people will test different 
  aspects of a program. If turning debug instructions on and off were 
  part of the PDL, then someone who wanted to turn a particular debug 
  instruction  on  would  have  to modify  the  PDL  file,  start the 
  compiler and link the new result.  By doing this he could come into 
  conflict with others who do  not want this debug instruction turned 
  on but perhaps  a different one. Similar  remarks hold equally well 
  for the pre-- and postconditions, class invariants, etc. 


  The simplest solution seems  to us to lie  in a clear separation of 
  Eiffel  compilation  on  the  one  hand  and  the  manifold control 
  possibilities on the other. 


  To this end Eiffel/S offers the RCL (Runtime Control Language): you 
  produce an ASCII file describing  your wishes with respect to debug 
  clauses, assertions, etc  (written in RCL).  Using the RCL compiler 
  you  translate your  RCL file  into  binary format.  The executable 
  Eiffel  program  reads  this  binary  file  and  sets  all internal 
  switches  accordingly. If  many  different people  are  running the 
  program with different  settings, each of  them can set  up his own 
  private RCL  file. There  only need be  one copy  of the executable 
  program. 


  A further advantage of this method  is that you only need to modify 
  your RCL file,  run the RCL  compiler and start  the Eiffel program 
  again to get different  settings. That is a  matter of only seconds 
  ---  in  contrast to  recompiling  and relinking  an  entire Eiffel 
  program (which  even with a  very fast Eiffel  compiler still takes 
  more than a few seconds). 


  
3.2 The RCL Compiler ercc 
==========================

  The compiler for the  (simple) language RCL is  called ercc. It is 
  started as follows: 

  ercc [ program_name ] 

  Here program_name is the name  of the executable program and also 
  the name  of the corresponding  RCL file.  If you do  not give this 
  name on the command line the RCL  compiler will ask you for it. The 
  full name of the RCL file is: 

  program_name.rcl 



Example 

  Let us suppose your  program has the name  my_prog. Then the RCL 
  file for this  program must be  called my_prog.rcl. To translate 
  this file you simply enter 

  ercc my_prog 

  If there are no errors in the RCL file the compiler will generate a 
  binary file with the name my_prog.rcb (`b' for ``binary''). 


  Now when you start  your Eiffel program my_prog  it will look for 
  an ``rcb'' file of the same name. The search for this file proceeds 
  as follows: 


* First in the current cluster. 
* Then in the cluster in which my_prog itself lies. 

    If the search  is successful and  the file found  has the correct 
  ``rcb'' format, then the corresponding settings will be established 
  before the program is executed. 


  Please  note that  all  switches are  put  in the  default position 
  before the ``rcb'' file is read. If  such a file is not found or if 
  it is  not a valid  ``rcb'' file  these default values  will not be 
  changed.  If the  ``rcb''  file is  found  and is  valid,  then all 
  switches will be set as given in the file. 


  
3.3 Default RCL file 
=====================

  If ercc does  not find the given  RCL file it  asks you whether you 
  want   such   a  file   generated  automatically.   If  you  answer 
  affirmatively, such a  file with the desired  name is generated and 
  translated immediately.  You can later  alter the  contents of this 
  file to meet your special needs. 


  
3.4 The structure of an RCL file 
=================================

  Since  RCL is  a very  simple language  we won't  bother to  give a 
  formal  definition of  the language.  Instead  we give  an informal 
  description of the individual language constructs. 


  
3.5 Comments 
============

  You can insert  comments at any  position in an  RCL file. Comments 
  follow the Eiffel convention: a comment begins with -- and consists 
  of arbitrary characters. It extends to the end of the line. 


  
3.6 Keywords 
============

  all  : Always means: the  corresponding option is turned 
         on for all classes belonging to the program. 

  none : Always means: the corresponding option is turned off for all 
         classes belonging to  the program. You can  achieve the same effect 
         by leaving out the clause altogether. 

  on   : Turn the option on. 

  off  : Turn the option off. 

  
3.7 Terminals 
=============

  name  : A class  name, i.e. a string representing a legal 
          Eiffel class. 
  key   : A string representing a legal debug key. 
  number: An integer. 

  
3.8 The language constructs 
===========================

  We come now to the individual language constructs. The order in the 
  RCL file is arbitrary. The same construct may occur more than once. 
  If it describes a set of class names or debug keys the union of the 
  sets will be formed. In all  other cases the last such construct in 
  the text will be the one to take effect. 


3.8.1 class_list 

  A list of  name (class names), optionally  separated by commas. The 
  list can be empty and may extend over several lines. 



3.8.2 key_list 

  A list  of key  (debug keys),  optionally separated  by commas. The 
  list can be empty and may extend over several lines. 



3.8.3 preconditions 

  precondition ":" (all | none | class_list) 

  Determines for which classes precondition checking is turned on. 

  Default: All precondition checks turned off. 



3.8.4 postconditions 

  postcondition ":" (all | none | class_list) 

  Determines for which classes postcondition checking is turned on. 

  Important note 
  ==============

  In any class in which  postconditions are checked preconditions are 
  automatically checked. 


  Default: All postcondition checks turned off. 



3.8.5 loop_variant 

  loop_variant ":" (all | none | class_list) 

  Determines for which classes loop variant checking is turned on. 

  Default: All loop variant checks turned off. 


  
3.8.6 loop_invariant 

  loop_invariant ":" (all | none | class_list) 

  Determines for which classes loop invariant checking is turned on. 

  Default: All loop invariant checks turned off. 


  
3.8.7 invariant 

  invariant ":" (all | none | class_list) 

  Determines for which classes class invariant checking is turned on. 

  Default: All class invariant checks turned off. 


  
3.8.8 check 

  check ":" (all | none | class_list) 

  Determines for which classes check instructions are turned on. 

  Default: All check instructions turned off. 


3.8.9 trace

  trace ":" (all | none | class_list) 

  Determines for which classes the execution tracer is turned on.
  When enabled for class C, all routines will write information to the file
  'etrace' in the cluster where the program was started.

  Default: All trace instructions turned off. 


3.8.10 debug 

  debug ":" (all | none | class_list) 

  Determines for which classes debug instructions are turned on. 

  Default: All debug instructions turned off. 


  
3.8.11 debug_key 

  debug_key ":" key_list 

  Specifies   the  list  of  debug  keys  whose  corresponding  debug 
  instructions are to be executed. 

Remark 

  Debug keys are independent of  the option debug. They can activate 
  a particular debug  instruction associated with  the given key even 
  though debug clauses are otherwise turned off. 

  Default: No debug keys activated. 


  
3.8.12 collect 

  collect ":" (on | off) 

  The garbage collector is normally always turned on; thus specifying 
  on  here is  actually  redundant. If  you  specify off  the garbage 
  collector will be  turned off at  program startup. It  is of course 
  possible to turn it on again from within a running program. See the 
  description of  the class  INTERNAL in  Section 2.8  of the library 
  manual as well as Chapter 6 of this manual. 


  
3.8.13 threshold 

  threshold ":" number 

  The garbage  collector is  not activated as  long as  the amount of 
  dynamically allocated memory  never exceeds number  bytes. See also 
  Chapter 6 of this manual. 

  

3.8.14 cache_size 

  cache_size ":" number 

  Specifies the number of memory pages (each  1 Kb) to be used by the 
  buffer cache in the  runtime file system. If  number is 0 the cache 
  mechanism is not used. 


  Default : Depends on the operating system. 


  
3.8.15 max_handles 


  max_handles ":" number 

  Specifies the maximum number of  operating system file handles kept 
  open by  the file  manager. Please  note that  the Eiffel/S runtime 
  system  can  keep  arbitrarily  many  files  ``open''  in  parallel 
  although the operating system generally sets an upper limit. 


  Default : Depends on the operating system. 

  
3.9 An example 

  An RCL file could look as follows: 

  precondition : WINDOW, LIST 
  postcondition : FILE 
  loop_variant : all 
  invariant :  all 
  debug  : none  
  debug_keys :  TEST, "inside routine xyz" 
  trace: WINDOW
  cache_size : 64 

  This means: 


  Preconditions will be tested only  in the classes WINDOW, LIST and 
  FILE; in  the class FILE  this happens  because postconditions are 
  being tested there. Postcondition checking is turned on only in the 
  class FILE. Loop variants and  class invariants are always tested. 
  All debug clauses  with the keys  TEST or "inside  routine xyz" are 
  turned on, all others  turned off. And finally  the program uses 64 
  Kb of cache buffers for file operations. 

