-----------------------------------------------------------
--                   Eiffel/S examples                   --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   SAMPLER

inherit
    INTERACT
    end

creation
    make

feature

    oper : CHARACTER

-----------------------------------------------------------

    make is

        local
            err : BOOLEAN

        do
            if not err then
                from
                    show_menu
                    get_a_character (">")
                until
                    the_character = 'q'
                loop
                    inspect the_character

                    when '1' then
                        list_demo
                    when '2' then
                        s_list_demo
                    when '3' then
                        smp_tbl_demo
                    when '4' then
                        s_table_demo
                    when '5' then
                        hash_demo
                    when '6' then
                        stack_demo
                    when '7' then
                        queue_demo
                    when '8' then
                        prqueue_demo
                    when '9' then
                        kprqueue_demo
                    else
                        io.put_string ("Unknown command%N")
                    end

                    show_menu
                    get_a_character (">")
                end
            end

            io.put_newline

        rescue
            err := true
            retry
        end
-----------------------------------------------------------

    show_menu is

        do
            io.put_string ("Choose a data structure by entering the number%N")
            io.put_string ("1)  list%N")
            io.put_string ("2)  sorted list%N")
            io.put_string ("3)  simple table%N")
            io.put_string ("4)  sorted table%N")
            io.put_string ("5)  hash table%N")
            io.put_string ("6)  stack%N")
            io.put_string ("7)  queue%N")
            io.put_string ("8)  priority queue%N")
            io.put_string ("9)  keyed priority queue%N")
            io.put_string ("q)  quit%N")
            io.put_newline
        end
-----------------------------------------------------------

    list_demo is

        local
            l  : LIST [STRING]
            it : ITERATOR

        do
            !!l.make (false)

            from
                get_operation (true, false, false)
            until
                oper = 'q'
            loop
                inspect oper

                when 'a' then
                    get_a_string ("A string : ")
                    l.add (the_string)

                when 'c' then
                    io.put_string ("count = ")
                    io.put_int (l.count)
                    io.put_newline

                when 'l' then
                    from
                        it := l.iterator
                    until
                        it.finished
                    loop
                        io.put_string (l.item (it))
                        io.put_newline

                        it.forth
                    end

                when 'r' then
                    if l.empty then
                        io.put_string ("Can't remove from empty container%N")
                    else
                        get_a_string ("A string : ")
                        l.remove (the_string)
                    end

                when 's' then
                    get_a_string ("A string : ")
                    l.search (the_string)

                    if l.found then
                        io.put_string ("Found%N")
                    else
                        io.put_string ("Not found%N")
                    end
                end

                get_operation (true, false, false)
            end
        end
-----------------------------------------------------------

    s_list_demo is

        local
            l  : SORTED_LIST [INTEGER]
            it : TWOWAY_ITER

        do
            !!l.make (false)

            from
                get_operation (true, true, false)
            until
                oper = 'q'
            loop
                inspect oper

                when 'a' then
                    get_an_integer ("An integer : ")
                    l.add (the_integer)

                when 'b' then
                    from
                        get_an_integer ("Starting at : ")
                        it := l.iter_before (the_integer)
                    until
                        it.finished
                    loop
                        io.put_int (l.item (it))
                        io.put_newline

                        it.back
                    end

                when 'c' then
                    io.put_string ("count = ")
                    io.put_int (l.count)
                    io.put_newline

                when 'l' then
                    from
                        get_an_integer ("Starting at : ")
                        it := l.iter_after (the_integer)
                    until
                        it.finished
                    loop
                        io.put_int (l.item (it))
                        io.put_newline

                        it.forth
                    end

                when 'r' then
                    if l.empty then
                        io.put_string ("Can't remove from empty container%N")
                    else
                        get_an_integer ("An integer : ")
                        l.remove (the_integer)
                    end

                when 's' then
                    get_an_integer ("An integer : ")
                    l.search (the_integer)

                    if l.found then
                        io.put_string ("Found%N")
                    else
                        io.put_string ("Not found%N")
                    end
                end

                get_operation (true, true, false)
            end
        end
-----------------------------------------------------------

    smp_tbl_demo is

        local
            t  : SIMPLE_TABLE [STRING, INTEGER]
            it : ITERATOR

        do
            !!t.make (false)

            from
                get_operation (true, false, true)
            until
                oper = 'q'
            loop
                inspect oper

                when 'a' then
                    get_a_string   ("A string   : ")
                    get_an_integer ("An integer : ")
                    t.add (the_integer, the_string)

                when 'c' then
                    io.put_string ("count = ")
                    io.put_int (t.count)
                    io.put_newline

                when 'e' then
                    get_a_string   ("A string   : ")
                    get_an_integer ("An integer : ")
                    t.replace (the_integer, the_string)

                when 'l' then
                    from
                        it := t.iterator
                    until
                        it.finished
                    loop
                        io.put_string (t.key (it))
                        io.put_string (", ")
                        io.put_int (t.item (it))
                        io.put_newline

                        it.forth
                    end

                when 'r' then
                    if t.empty then
                        io.put_string ("Can't remove from empty container%N")
                    else
                        get_a_string ("A string : ")
                        t.remove (the_string)
                    end

                when 's' then
                    get_a_string ("A string : ")
                    t.search (the_string)

                    if t.found then
                        io.put_string ("Found: item is ")
                        io.put_int (t.found_item)
                        io.put_newline
                    else
                        io.put_string ("Not found%N")
                    end
                end

                get_operation (true, false, true)
            end
        end
-----------------------------------------------------------

    s_table_demo is

        local
            t  : SORTED_TABLE [INTEGER, STRING]
            it : TWOWAY_ITER

        do
            !!t.make (false)

            from
                get_operation (true, true, true)
            until
                oper = 'q'
            loop
                inspect oper

                when 'a' then
                    get_a_string   ("A string   : ")
                    get_an_integer ("An integer : ")
                    t.add (the_string, the_integer)

                when 'b' then
                    from
                        get_an_integer ("Starting at : ")
                        it := t.iter_before (the_integer)
                    until
                        it.finished
                    loop
                        io.put_int (t.key (it))
                        io.put_string (", ")
                        io.put_string (t.item (it))
                        io.put_newline

                        it.back
                    end

                when 'c' then
                    io.put_string ("count = ")
                    io.put_int (t.count)
                    io.put_newline

                when 'e' then
                    get_a_string   ("A string   : ")
                    get_an_integer ("An integer : ")
                    t.replace (the_string, the_integer)

                when 'l' then
                    from
                        get_an_integer ("Starting at : ")
                        it := t.iter_after (the_integer)
                    until
                        it.finished
                    loop
                        io.put_int (t.key (it))
                        io.put_string (", ")
                        io.put_string (t.item (it))
                        io.put_newline

                        it.forth
                    end

                when 'r' then
                    if t.empty then
                        io.put_string ("Can't remove from empty container%N")
                    else
                        get_an_integer ("An integer : ")
                        t.remove (the_integer)
                    end

                when 's' then
                    get_an_integer ("An integer : ")
                    t.search (the_integer)

                    if t.found then
                        io.put_string ("Found: item is ")
                        io.put_string (t.found_item)
                        io.put_newline
                    else
                        io.put_string ("Not found%N")
                    end
                end

                get_operation (true, true, true)
            end
        end
-----------------------------------------------------------

    hash_demo is

        local
            t  : HASH_TABLE [STRING, INTEGER]
            it : ITERATOR

        do
            !!t.make (false, 32)

            from
                get_operation (true, false, true)
            until
                oper = 'q'
            loop
                inspect oper

                when 'a' then
                    get_a_string   ("A string   : ")
                    get_an_integer ("An integer : ")
                    t.add (the_integer, the_string)

                when 'c' then
                    io.put_string ("count = ")
                    io.put_int (t.count)
                    io.put_newline

                when 'e' then
                    get_a_string   ("A string   : ")
                    get_an_integer ("An integer : ")
                    t.replace (the_integer, the_string)

                when 'l' then
                    from
                        it := t.iterator
                    until
                        it.finished
                    loop
                        io.put_string (t.key (it))
                        io.put_string (", ")
                        io.put_int (t.item (it))
                        io.put_newline

                        it.forth
                    end

                when 'r' then
                    if t.empty then
                        io.put_string ("Can't remove from empty container%N")
                    else
                        get_a_string ("A string : ")
                        t.remove (the_string)
                    end

                when 's' then
                    get_a_string ("A string : ")
                    t.search (the_string)

                    if t.found then
                        io.put_string ("Found: item is ")
                        io.put_int (t.found_item)
                        io.put_newline
                    else
                        io.put_string ("Not found%N")
                    end
                end

                get_operation (true, false, true)
            end
        end
-----------------------------------------------------------

    stack_demo is

        local
            s : STACK [STRING]

        do
            !!s.make

            from
                get_operation (false, false, false)
            until
                oper = 'q'
            loop
                inspect oper

                when 'a' then
                    get_a_string ("A string : ")
                    s.add (the_string)

                when 'c' then
                    io.put_string ("count = ")
                    io.put_int (s.count)
                    io.put_newline

                when 'i' then
                    if s.empty then
                        io.put_string ("Container is empty%N")
                    else
                        io.put_string (s.item)
                        io.put_newline
                    end

                when 'r' then
                    if s.empty then
                        io.put_string ("Can't remove from empty container%N")
                    else
                        s.remove
                    end
                end

                get_operation (false, false, false)
            end
        end
-----------------------------------------------------------

    queue_demo is

        local
            q : QUEUE [STRING]

        do
            !!q.make

            from
                get_operation (false, false, false)
            until
                oper = 'q'
            loop
                inspect oper

                when 'a' then
                    get_a_string ("A string : ")
                    q.add (the_string)

                when 'c' then
                    io.put_string ("count = ")
                    io.put_int (q.count)
                    io.put_newline

                when 'i' then
                    if q.empty then
                        io.put_string ("Container is empty%N")
                    else
                        io.put_string (q.item)
                        io.put_newline
                    end

                when 'r' then
                    if q.empty then
                        io.put_string ("Can't remove from empty container%N")
                    else
                        q.remove
                    end
                end

                get_operation (false, false, false)
            end
        end
-----------------------------------------------------------

    prqueue_demo is

        local
            q : PRIORITY_QUEUE [INTEGER]

        do
            !!q.make

            from
                get_operation (false, false, false)
            until
                oper = 'q'
            loop
                inspect oper

                when 'a' then
                    get_an_integer ("An integer : ")
                    q.add (the_integer)

                when 'c' then
                    io.put_string ("count = ")
                    io.put_int (q.count)
                    io.put_newline

                when 'i' then
                    if q.empty then
                        io.put_string ("Container is empty%N")
                    else
                        io.put_int (q.item)
                        io.put_newline
                    end

                when 'r' then
                    if q.empty then
                        io.put_string ("Can't remove from empty container%N")
                    else
                        q.remove
                    end
                end

                get_operation (false, false, false)
            end
        end
-----------------------------------------------------------

    kprqueue_demo is

        local
            q : KEY_PRIORITY_QUEUE [INTEGER, STRING]

        do
            !!q.make

            from
                get_operation (false, false, false)
            until
                oper = 'q'
            loop
                inspect oper

                when 'a' then
                    get_an_integer ("An integer : ")
                    get_a_string   ("A string   : ")
                    q.add (the_integer, the_string)

                when 'c' then
                    io.put_string ("count = ")
                    io.put_int (q.count)
                    io.put_newline

                when 'i' then
                    if q.empty then
                        io.put_string ("Container is empty%N")
                    else
                        io.put_int (q.key)
                        io.put_string (", ")
                        io.put_string (q.item)
                        io.put_newline
                    end

                when 'r' then
                    if q.empty then
                        io.put_string ("Can't remove from empty container%N")
                    else
                        q.remove
                    end
                end

                get_operation (false, false, false)
            end
        end
-----------------------------------------------------------

    show_operations (listable, sorted, is_table : BOOLEAN) is

        do
            io.put_string ("Choose an operation%N")
            io.put_string ("a)  add an element%N")

            if sorted then
                io.put_string ("b)  list elements backward%N")
            end

            io.put_string ("c)  print count of elements%N")

            if not listable then
                io.put_string ("i)  show item%N")
            end
    
            if is_table then
                io.put_string ("e)  exchange items%N")
            end

            if listable then
                io.put_string ("l)  list elements forward%N")
            end

            io.put_string ("r)  remove an element%N") 

            if listable then
                io.put_string ("s)  search for element%N")
            end

            io.put_string ("q)  quit%N")
            io.put_newline
        end
-----------------------------------------------------------

    get_operation (listable, sorted, is_table : BOOLEAN) is

        local
            done : BOOLEAN

        do
            show_operations (listable, sorted, is_table) 
 
            from
                get_a_character  (">")
            until
                done
            loop
                oper := the_character

                if listable then
                    if sorted then
                        if  oper = 'a' or else
                            oper = 'b' or else
                            oper = 'c' or else
                            oper = 'e' or else
                            oper = 'l' or else 
                            oper = 'r' or else
                            oper = 's' or else
                            oper = 'q'
                        then
                            done := (is_table or else oper /= 'e')
                        end
                    else
                        if  oper = 'a' or else
                            oper = 'c' or else
                            oper = 'e' or else
                            oper = 'l' or else 
                            oper = 'r' or else
                            oper = 's' or else
                            oper = 'q'
                        then
                            done := (is_table or else oper /= 'e')
                        end
                    end
                else
                    if oper = 'a' or else
                       oper = 'c' or else
                       oper = 'i' or else 
                       oper = 'r' or else
                       oper = 'q'
                    then
                        done := true
                    end
                end

                if not done then
                    io.put_string ("Unknown operation; try again%N")
                    get_a_character (">")
                end
            end
        end

end -- class SAMPLER

