-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   BASIC_IO
                        -- Simple I/O facilities.

-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    last_string : STRING is
                        -- Last string read with `get_string'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_lstring"
        end
-----------------------------------------------------------

    last_int : INTEGER is
                        -- Last integer read with `get_int'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_lint"
        end
-----------------------------------------------------------

    last_real : REAL is
                        -- Last real read with `get_real'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_lreal"
        end
-----------------------------------------------------------

    last_double : DOUBLE is
                        -- Last double read with `get_double'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_lreal"
        end
-----------------------------------------------------------

    last_bool : BOOLEAN is
                        -- Last boolean read with `get_bool'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_lbool"
        end
-----------------------------------------------------------

    last_char : CHARACTER is
                        -- Last character read with `get_char'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_lchar"
        end
-----------------------------------------------------------

    get_string is
                        -- Read a string from the standard
                        -- input and assign it to `last_string'.
                        -- NOTE: Every call will allocate a
                        -- new string.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_gstring"
        end
-----------------------------------------------------------

    get_int is
                        -- Read an integer from the standard
                        -- input and assign it to `last_int'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_gint"
        ensure
            integer_input : -- Input can be interpreted as integer
        end
-----------------------------------------------------------

    get_real is
                        -- Read a real from the standard
                        -- input and assign it to `last_real'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_greal"
        ensure
            real_input : -- Input can be interpreted as real
        end
-----------------------------------------------------------

    get_double is
                        -- Read a double from the standard
                        -- input and assign it to `last_double'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_greal"
        ensure
            double_input : -- Input can be interpreted as double
        end
-----------------------------------------------------------

    get_bool is
                        -- Read a boolean from the standard
                        -- input and assign it to `last_bool'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_gbool"
        ensure
            boolean_input : -- Input can be interpreted as boolean
        end
-----------------------------------------------------------

    get_char is
                        -- Read a character from the standard
                        -- input and assign it to `last_char'.
                        -- NOTE: Empty input is interpreted as
                        --       `%N'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_gchar"
        end
-----------------------------------------------------------

    get_newline is
                        -- Consume input until newline is found,
                        -- then consume newline character.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_gnewline"
        end
-----------------------------------------------------------

    put_string (s : STRING) is
                        -- Output `s' to current output device.
        require
            string_not_void : s /= Void
        do
            rt_string (s.to_external, output_device)
        end
-----------------------------------------------------------

    put_int (i : INTEGER) is
                        -- Output `i' to current output device.
        do
            rt_int (i, output_device)
        end
-----------------------------------------------------------

    put_real (r : REAL) is
                        -- Output `r' to current output device.
        do
            rt_real (r, output_device)
        end
-----------------------------------------------------------

    put_double (d : DOUBLE) is
                        -- Output `d' to current output device.
        do
            rt_real (d, output_device)
        end
-----------------------------------------------------------

    put_bool (b : BOOLEAN) is
                        -- Output `b' to current output device.
                        -- NOTE: Prints `true' or `false'.
        do
            if b then
                put_string ("true")
            else
                put_string ("false")
            end
        end
-----------------------------------------------------------

    put_char (c : CHARACTER) is
                        -- Output `c' to current output device.
        do
            rt_char (c, output_device)
        end
-----------------------------------------------------------

    put_newline is
                        -- Output newline character.
        do
            rt_newline (output_device)
        end
-----------------------------------------------------------

    end_of_input : BOOLEAN is
                        -- Has end-of-input been reached on
                        -- standard input?
        external "C" -- changed by x_c_cwc
        alias    "RTC1_end_of_input"
        end
-----------------------------------------------------------

    set_standard_output is
                        -- Use the standard output device from
                        -- now on.
        do
            output_device := Stdout
        end
-----------------------------------------------------------

    set_error_output is
                        -- Use the error output device from
                        -- now on.
        do
            output_device := Stderr
        end
-----------------------------------------------------------
feature {NONE}
-----------------------------------------------------------

    Stdout        : INTEGER is 0
    Stderr        : INTEGER is 1

    output_device : INTEGER

-----------------------------------------------------------

    rt_string (s : POINTER, device : INTEGER) is
                        -- Output `s' to output device `device'.
        external "C" -- changed by x_c_cwc
        alias    "RTC1_pstring"
        end
-----------------------------------------------------------

    rt_int (i : INTEGER, device : INTEGER) is
                        -- Output `i' to output device `device'
        external "C" -- changed by x_c_cwc
        alias    "RTC1_pint"
        end
-----------------------------------------------------------

    rt_real (r : REAL, device : INTEGER) is
                        -- Output `r' to output device `device'
        external "C" -- changed by x_c_cwc
        alias    "RTC1_preal"
        end
-----------------------------------------------------------

    rt_char (c : CHARACTER, device : INTEGER) is
                        -- Output `c' to output device `device'
        external "C" -- changed by x_c_cwc
        alias    "RTC1_pchar"
        end
-----------------------------------------------------------

    rt_newline (device : INTEGER) is
                        -- Output newline to output device `device'
        external "C" -- changed by x_c_cwc
        alias    "RTC1_pnewline"
        end
-----------------------------------------------------------

end -- class BASIC_IO

