-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class  INTEGER_REF

inherit
    NUMERIC
        redefine
            infix "+", infix "-", infix "*", infix "/",
            infix "^", prefix "-", prefix "+", valid_divisor,
            one, zero
    end

    COMPARABLE
        redefine
            infix "<", compare
    end

    HASHABLE
        redefine
            hash_code
    end
-----------------------------------------------------------
creation {ANY}
    make
-----------------------------------------------------------
feature {ANY}
-----------------------------------------------------------

    item : INTEGER

-----------------------------------------------------------

    make (value : INTEGER) is

        do
            item := value
        end
-----------------------------------------------------------

    infix "+" (other : INTEGER_REF) : INTEGER_REF is
                        -- Add `other' to Current.
        do
            !!Result.make (item + other.item)
        end
-----------------------------------------------------------

    infix "-" (other : INTEGER_REF) : INTEGER_REF is
                        -- Subtract `other' from Current.
        do
            !!Result.make (item - other.item)
        end
-----------------------------------------------------------

    infix "*" (other : INTEGER_REF) : INTEGER_REF is
                        -- Multiply `other' by Current.
        do
            !!Result.make (item * other.item)
        end
-----------------------------------------------------------

    infix "/" (other : INTEGER_REF) : INTEGER_REF is
                        -- Divide Current by `other'.
                        -- Note : Integer division
        do
            !!Result.make (item / other.item)
        end
-----------------------------------------------------------

    infix "//" (other : INTEGER_REF) : INTEGER_REF is
                        -- Divide Current by `other'.
                        -- Note : Integer division
        require
            valid_divisor : valid_divisor (other)
        do
            !!Result.make (item // other.item)
        end
-----------------------------------------------------------

    infix "\\" (other : INTEGER_REF) : INTEGER_REF is
                        -- Remainder of division of Current by `other'.
        require
            valid_modulus : valid_divisor (other)
        do
            !!Result.make (item \\ other.item)
        end
-----------------------------------------------------------

    infix "^" (exp : INTEGER) : INTEGER_REF is
                        -- Raise Current to `exp'-th power.
        do
            !!Result.make (item ^ exp)
        end
-----------------------------------------------------------

    infix "<" (other : INTEGER_REF) : BOOLEAN is
                        -- Is Current less than `other'?
        do
            Result := (item < other.item)
        end
-----------------------------------------------------------

    prefix "+" : INTEGER_REF is

        do
            !!Result.make (item)
        end
-----------------------------------------------------------

    prefix "-" : INTEGER_REF is
                        -- Unary minus of Current
        do
            !!Result.make (-item)
        end
-----------------------------------------------------------

    compare (other : INTEGER_REF) : INTEGER is
                        -- Compare Current with `other'.
                        -- '<' <==> Result < 0
                        -- '>' <==> Result > 0
                        -- Otherwise Result = 0
        do
            Result := item - other.item
        end
-----------------------------------------------------------

    hash_code : INTEGER is

        do
            if item < 0 then
                Result := -item
            else
                Result := item
            end
        end
-----------------------------------------------------------

    valid_divisor (other : INTEGER_REF) : BOOLEAN is

        do
            Result := (other.item /= 0)
        end
-----------------------------------------------------------

    one : INTEGER_REF is

        do
            !!Result.make (1)
        end
-----------------------------------------------------------

    zero : INTEGER_REF is

        do
            !!Result.make (0)
        end
-----------------------------------------------------------

end -- class INTEGER_REF

