-----------------------------------------------------------
--                   Eiffel/S libraries                  --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
deferred class  NUMERIC
                        -- This class describes a ring.
-----------------------------------------------------------
feature {ANY} 
-----------------------------------------------------------

    infix "+" (other : like Current) : like Current is
                        -- Sum of 'Current' and 'other'.
        require
            other_not_void : other /= Void
        deferred
        end
-----------------------------------------------------------

    infix "-" (other : like Current) : like Current is
                        -- Difference of 'Current' and 'other'.
        require
            other_not_void : other /= Void
        deferred
        end
-----------------------------------------------------------

    infix "*" (other : like Current) : like Current is
                        -- Product of 'Current' and 'other'.
        require
            other_not_void : other /= Void
        deferred
        end
-----------------------------------------------------------

    infix "/" (other : like Current) : like Current is
                        -- Quotient of 'Current' and 'other'.
        require
            other_not_void : other /= Void
            valid_divisor  : valid_divisor (other)
        deferred
        end
-----------------------------------------------------------

    infix "^" (exp : INTEGER) : like Current is
                        -- 'Current' raised to 'exp'-th power.
        require
            non_negative_exponent : exp >= 0
        local
            e       : INTEGER
            product : like Current 
            factor  : like Current
        do
            product := one
            factor  := Current

            from
                e := exp
            until
                e = 0
            loop
                if (e \\ 2) = 1 then
                    product := product * factor
                end

                e := e // 2
                factor := factor * factor
            end
            Result := product
        end
-----------------------------------------------------------

    prefix "+" : like Current is
                        -- Unary plus of 'Current'.
        do
            Result := Current
        end
-----------------------------------------------------------

    prefix "-" : like Current is
                        -- Negative of 'Current'.
        do
            Result := zero - Current
        end
-----------------------------------------------------------

    valid_divisor (other : like Current) : BOOLEAN is
                        -- Is 'other' a valid divisor for 'Current'?
        require
            other_not_void : other /= Void
        deferred
        end
-----------------------------------------------------------

    one : like Current is
                    -- The neutral element of multiplication.
        deferred
        ensure
            neutral_element : -- Result is the neutral element of 
                              -- multiplication.
        end
-----------------------------------------------------------

    zero : like Current is
                    -- The neutral element of addition.
        deferred
        ensure
            neutral_element : -- Result is the neutral element of 
                              -- addition.
        end
-----------------------------------------------------------

end -- class NUMERIC

